/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.logging;

import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogFormatAdapter;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.helpers.MarkerIgnoringBase;

public class ConsoleLogger
extends MarkerIgnoringBase {
    public static final String DEFAULT_COMPONENT_TAG = "Sealights";
    private static final String PREFIX_DEFALUT_FMT = "[%s] [%s]";
    private static String componentTag = "Sealights";
    private final Level level;
    private String prefix = null;
    private static final String agentId = AgentId.getAgentId();

    public static String formattedPrefix(String contextTag) {
        return String.format(PREFIX_DEFALUT_FMT, contextTag, StringUtils.getFirstNChars(agentId, 2));
    }

    public static void initComponentTag(String tag) {
        componentTag = tag;
    }

    public static String getComponentTag() {
        return componentTag;
    }

    public ConsoleLogger(String context) {
        this(context, Level.INFO);
    }

    public ConsoleLogger(Level level) {
        this(componentTag, level);
    }

    public ConsoleLogger(String context, Level level) {
        this.prefix = ConsoleLogger.formattedPrefix(context);
        this.level = level;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void println(String text) {
        System.out.println(this.format(text));
    }

    public void status(String message) {
        this.println(message);
    }

    private void printInfo(String text) {
        if (this.isInfoEnabled()) {
            this.println(text);
        }
    }

    public void printWarn(String text) {
        if (this.isWarnEnabled()) {
            this.println("[WARN] - " + text);
        }
    }

    public void printError(String text, Throwable t) {
        this.printError(this.messageWithThrowable(text, t));
    }

    public void printError(String text) {
        if (this.isErrorEnabled()) {
            System.err.println(this.format(text));
        }
    }

    public void printDebug(String text) {
        if (this.isDebugEnabled()) {
            this.println("[DEBUG] - " + text);
        }
    }

    public void printTrace(String text) {
        if (this.isTraceEnabled()) {
            this.println("[TRACE] - " + text);
        }
    }

    private String messageWithThrowable(String message, Throwable t) {
        return message + ", error: " + this.toStringException(t);
    }

    private String toStringException(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private String format(String msg) {
        return String.format("%s - %s", this.prefix, msg);
    }

    @Override
    public boolean isTraceEnabled() {
        return Level.TRACE.enabledAt(this.level);
    }

    @Override
    public void trace(String string) {
        this.printTrace(string);
    }

    @Override
    public void trace(String format, Object arg) {
        this.printTrace(LogFormatAdapter.normalizedMessage(format, arg));
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.printTrace(LogFormatAdapter.normalizedMessage(format, arg1, arg2));
    }

    @Override
    public void trace(String format, Object ... args) {
        this.printTrace(LogFormatAdapter.normalizedMessage(format, args));
    }

    @Override
    public void trace(String text, Throwable t) {
        this.printTrace(this.messageWithThrowable(text, t));
    }

    @Override
    public boolean isDebugEnabled() {
        return Level.DEBUG.enabledAt(this.level);
    }

    @Override
    public void debug(String string) {
        this.printDebug(string);
    }

    @Override
    public void debug(String format, Object arg) {
        this.printDebug(LogFormatAdapter.normalizedMessage(format, arg));
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.printDebug(LogFormatAdapter.normalizedMessage(format, arg1, arg2));
    }

    @Override
    public void debug(String format, Object ... args) {
        this.printDebug(LogFormatAdapter.normalizedMessage(format, args));
    }

    @Override
    public void debug(String text, Throwable t) {
        this.printDebug(this.messageWithThrowable(text, t));
    }

    @Override
    public boolean isInfoEnabled() {
        return Level.INFO.enabledAt(this.level);
    }

    @Override
    public void info(String string) {
        this.printInfo(string);
    }

    @Override
    public void info(String format, Object arg) {
        this.printInfo(LogFormatAdapter.normalizedMessage(format, arg));
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.printInfo(LogFormatAdapter.normalizedMessage(format, arg1, arg2));
    }

    @Override
    public void info(String format, Object ... args) {
        this.printInfo(LogFormatAdapter.normalizedMessage(format, args));
    }

    @Override
    public void info(String text, Throwable t) {
        this.printInfo(this.messageWithThrowable(text, t));
    }

    @Override
    public boolean isWarnEnabled() {
        return Level.WARN.enabledAt(this.level);
    }

    @Override
    public void warn(String string) {
        this.printWarn(string);
    }

    @Override
    public void warn(String format, Object arg) {
        this.printWarn(LogFormatAdapter.normalizedMessage(format, arg));
    }

    @Override
    public void warn(String format, Object ... args) {
        this.printWarn(LogFormatAdapter.normalizedMessage(format, args));
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.printWarn(LogFormatAdapter.normalizedMessage(format, arg1, arg2));
    }

    @Override
    public void warn(String text, Throwable t) {
        this.printWarn(this.messageWithThrowable(text, t));
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public void error(String string) {
        this.printError(string);
    }

    @Override
    public void error(String format, Object arg) {
        this.printError(String.format(LogFormatAdapter.normalizeFormat(format), arg));
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.printError(String.format(LogFormatAdapter.normalizeFormat(format), arg1, arg2));
    }

    @Override
    public void error(String format, Object ... args) {
        this.printError(LogFormatAdapter.normalizedMessage(format, args));
    }

    @Override
    public void error(String string, Throwable e) {
        this.printError(string, e);
    }

    public Level getLevel() {
        return this.level;
    }
}

