/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.jarutils;

import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StreamUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.UUID;
import java.util.jar.JarFile;

public class JarReader {
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();

    public JarFile copyJarToTmpJarFile(File binaryCodeFile, String jarNameWithoutExtension, String filesStorage) {
        try {
            FileInputStream jarStream = new FileInputStream(binaryCodeFile);
            return this.copyJarStreamToTmpJarFile(jarStream, jarNameWithoutExtension, filesStorage);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load external jar: jarNameWithoutExtension:'" + jarNameWithoutExtension + "'. Error:", e);
        }
    }

    public File copyJarStreamToTmpFile(InputStream jarStream, String jarNameWithoutExtension, String storageFolderOrFile) throws Exception {
        File file = this.createTempJarFile(jarNameWithoutExtension, storageFolderOrFile);
        if (file != null) {
            StreamUtils.copyInputStreamToFile(jarStream, file);
            return file;
        }
        throw new RuntimeException(String.format("Cannot copy jar to file '%s': temporary file is 'null'", jarNameWithoutExtension));
    }

    public JarFile copyJarStreamToTmpJarFile(InputStream jarStream, String jarNameWithoutExtension, String storageFolderOrFile) throws Exception {
        File file = this.copyJarStreamToTmpFile(jarStream, jarNameWithoutExtension, storageFolderOrFile);
        if (file != null) {
            return new JarFile(file);
        }
        throw new RuntimeException(String.format("Failed to create temporary file for jar '%s'", jarNameWithoutExtension));
    }

    protected File createTempJarFile(String jarNameWithoutExtension, String fileStorage) throws Exception {
        File file = null;
        if (StringUtils.isNotEmpty(fileStorage)) {
            String tempFileName = jarNameWithoutExtension + "_" + UUID.randomUUID() + ".jar";
            file = this.createFileOnStorage(fileStorage, tempFileName);
        }
        if (file == null) {
            file = File.createTempFile(jarNameWithoutExtension, ".jar");
        }
        return this.setFileDeleteOnExit(file);
    }

    protected File createFileOnStorage(String filesStorage, String fileName) {
        File file = new File(filesStorage, fileName);
        try {
            if ((file.getParentFile().exists() || file.getParentFile().mkdirs()) && file.createNewFile()) {
                CONSOLE_LOG.debug("Created temporary file '{}'", (Object)file);
                return file;
            }
        }
        catch (Exception e) {
            CONSOLE_LOG.error("Failed to create file '{}'", (Object)fileName, (Object)e);
        }
        return null;
    }

    private File setFileDeleteOnExit(File file) {
        if (file != null) {
            file.deleteOnExit();
        }
        return file;
    }
}

