/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.jarutils;

import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarHelper {
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jarEntryToFile(JarFile jar, JarEntry entry, String destFileName) throws IOException {
        File newEntryFile = new File(destFileName);
        InputStream in = null;
        OutputStream out = null;
        try {
            int length;
            in = jar.getInputStream(entry);
            out = new FileOutputStream(newEntryFile);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public static List<JarEntry> jarEntriesAsList(JarFile jar) throws Exception {
        ArrayList<JarEntry> entriesList = new ArrayList<JarEntry>();
        Enumeration<JarEntry> entryEnumeration = jar.entries();
        while (entryEnumeration.hasMoreElements()) {
            entriesList.add(entryEnumeration.nextElement());
        }
        return entriesList;
    }

    public static String createTempFile(JarFile jar, JarEntry entry, String name) {
        String fileStorage = System.getProperty("sl.fileStorage");
        String tempDir = fileStorage != null ? fileStorage : System.getProperty("java.io.tmpdir");
        String newFileName = tempDir + File.separatorChar + name;
        try {
            JarHelper.jarEntryToFile(jar, entry, newFileName);
            return newFileName;
        }
        catch (Exception e) {
            CONSOLE_LOG.info("Error while trying to write  to file. Error: {}", e);
            return null;
        }
    }

    public static void closeJar(JarFile jar) {
        if (jar != null) {
            try {
                jar.close();
            }
            catch (IOException e) {
                CONSOLE_LOG.info("Error while trying to close jar '{}' ", (Object)jar.getName(), (Object)e);
            }
        }
    }
}

