/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.utils;

import io.sealights.onpremise.agents.infra.http.utils.NoOpTrustManager;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;

public final class SSLCertificateHandler {
    private static final Logger CONSOLE_LOG = LogFactory.getLogger(SSLCertificateHandler.class);
    private static final String SSL = "SSL";
    private static final String SunJSSE = "SunJSSE";
    private static volatile boolean sslInitVisited = false;
    private static SSLContext sslContext;

    public static SSLContext createCustomSSLContext() {
        if (sslInitVisited || !SSLCertificateHandler.shouldCreateCustomSSLContext()) {
            return sslContext;
        }
        try {
            SSLCertificateHandler.initSSLContext();
        }
        catch (Throwable e) {
            String error = "Failed configure to ignore SSL certificate errors";
            CONSOLE_LOG.error("{}. Error", (Object)"Failed configure to ignore SSL certificate errors", (Object)e);
            throw new RuntimeException("Failed configure to ignore SSL certificate errors");
        }
        finally {
            sslInitVisited = true;
        }
        return sslContext;
    }

    public static HostnameVerifier getAnyHostTrustedVerifier() {
        HostnameVerifier anyHostTrusted = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        return anyHostTrusted;
    }

    private static void initSSLContext() throws Exception {
        if (SSLCertificateHandler.shouldUseSunJSSEProvider()) {
            sslContext = SSLContext.getInstance(SSL, SunJSSE);
            CONSOLE_LOG.info("Sun JSSE provider is configured.");
        } else {
            sslContext = SSLContext.getInstance(SSL);
        }
        sslContext.init(null, SSLCertificateHandler.createCustomTrustManager(), new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        if (SSLCertificateHandler.shouldIgnoreCertificateErrors()) {
            HttpsURLConnection.setDefaultHostnameVerifier(SSLCertificateHandler.getAnyHostTrustedVerifier());
            CONSOLE_LOG.info("SSLContext is configured to ignore SSL certificate errors.");
        }
    }

    private static TrustManager[] createCustomTrustManager() {
        if (SSLCertificateHandler.shouldIgnoreCertificateErrors()) {
            return new TrustManager[]{new NoOpTrustManager()};
        }
        return null;
    }

    private static boolean shouldCreateCustomSSLContext() {
        return SSLCertificateHandler.shouldIgnoreCertificateErrors() || SSLCertificateHandler.shouldUseSunJSSEProvider();
    }

    public static boolean shouldIgnoreCertificateErrors() {
        return Boolean.getBoolean("sl.ignoreCertificateErrors");
    }

    private static boolean shouldUseSunJSSEProvider() {
        return Boolean.getBoolean("sl.useSunJsseProvider");
    }
}

