/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.utils;

import com.lowagie.text.pdf.OcspClientBouncyCastle;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClientFactory;
import io.sealights.onpremise.agents.infra.http.testapp.TestProxy;
import io.sealights.onpremise.agents.java.agent.test.infra.junit.JUnitTestBase;
import io.sealights.onpremise.agents.java.agent.test.infra.junit.VerboseTestJUnit;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class BouncyCastleProviderTest
extends JUnitTestBase {
    private static final String TOKEN = "eyJhbGciOiJSUzUxMiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJodHRwczovL1BST0QtU1RBR0lORy5hdXRoLnNlYWxpZ2h0cy5pby8iLCJqd3RpZCI6IlBST0QtU1RBR0lORyxpLTBmNDM4MzlkY2RkZjBiOWYwLEFQSUdXLTgzOTRjOGM1LTg3NjAtNGNlMS1hMGUxLTM3NDQ5Zjc2OGM3MCwxNDgyNzU0MzU2NDYyIiwic3ViamVjdCI6IlNlYUxpZ2h0c0BhZ2VudCIsImF1ZGllbmNlIjpbImFnZW50cyJdLCJ4LXNsLXJvbGUiOiJhZ2VudCIsIngtc2wtc2VydmVyIjoiaHR0cHM6Ly9QUk9ELVNUQUdJTkctZ3cuc2VhbGlnaHRzLmNvL2FwaSIsInNsX2ltcGVyX3N1YmplY3QiOiIiLCJpYXQiOjE0ODI3NTQzNTZ9.U8NpiMsIiDaCd7CXJk8ieLLrf0D32ITgl2UuTLmKTsJldbKQIMv0OE31FOE6PEzJZn_A6JEAmSKQ9qcPP_MpWHI7UOfaTgtIhI-02MiXhipuFX9JMYBrHwiUAh1JQIwseny1C_qc2BBDaRkQydjcPW3WqAQrAAkzP6C0EAx691JEPV64OQEwt56req930SS11UJJpaZlMg4l0_M1w3Z3Vq1JlvWTJa746-RnNCxHilsH-bg0F4RNa5y1i81TiOkeF1a5azxj4LRQjq1QoRt8TNcRelUdUY_HflzJCNdADVaY54-ojb9fV9vO_XLJgPFhgrE-VcqZikM2VK1O4P2GeBT6nS9BiN8llheFd7L6bQILyK2AaUFiB82c-6HGttiRAuTKhi0pZpYzeBl2uh8RlZ-visKakxYptfaraJKTUDNwZluadJ1v6bnSbW-Mnp6Jak2ylsjtaj7ba6NuentCTRAF3L-VW3Y7V29srXbOWf-V_gpl2BXFiKOwiul7r2-pmVB5m3G2hddfKc2WW40w0d2lAvHSML97T80TcQWvVrkJuV40utEyYe-YCmA-ZeAWcd-21sPfHHgEKR-56jxYaLAxdu64aodA_kw0B_Y2zolfS3EY1E58KgvMYG9My3lqSfkKtBw5WyboSvTX4paQAQiTBshg3MazUTPkpdmXL9U";
    private static final String SERVER = "https://PROD-STAGING-gw.sealights.co/api";
    @Rule
    public VerboseTestJUnit verbose = new VerboseTestJUnit();

    @Test
    public void bouncyCastleOnTop_makeHttpRequest_requestOkAndProvidersOrderRestored() throws Exception {
        SLHttpClientFactory.resetForTestsOnly();
        this.putBouncyCastleProviderOnTop();
        List<String> providersBeforeRequest = this.providersToList();
        this.execHttpRequest();
        List<String> providersAfterRequest = this.providersToList();
        Assert.assertEquals(providersBeforeRequest, providersAfterRequest);
    }

    private void putBouncyCastleProviderOnTop() {
        Provider bc = null;
        X509Certificate cert = this.mockCertificate();
        OcspClientBouncyCastle x = new OcspClientBouncyCastle(cert, cert, "");
        try {
            x.getEncoded();
        }
        catch (Exception e) {
            for (Provider p : Security.getProviders()) {
                if (!p.getName().equals("BC")) continue;
                bc = p;
                break;
            }
        }
        if (bc == null) {
            throw new RuntimeException("Bouncy Castle was not found, test cannot be executed properly");
        }
        Security.removeProvider(bc.getName());
        Security.insertProviderAt(bc, 1);
    }

    private List<String> providersToList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Provider p : Security.getProviders()) {
            list.add(p.getName());
        }
        return list;
    }

    private void execHttpRequest() {
        new TestProxy(TOKEN, SERVER).executeRequest();
    }

    private X509Certificate mockCertificate() {
        X509Certificate certificate = (X509Certificate)Mockito.mock(X509Certificate.class);
        return certificate;
    }
}

