/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.testapp;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.custom.SLCustomHttpClient;
import io.sealights.onpremise.agents.infra.http.testapp.ProxyAuthenticator;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import sun.misc.BASE64Encoder;

public class TestApp {
    static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger("TEST");
    static String proxyConfig = "alash:ezPass123@54.246.193.96:5476";
    static ProxyInfo proxyInfo = new ProxyInfo(proxyConfig);
    static String TEST_HTTP_URL = "http://www.google.com";
    static String TEST_HTTPS_URL = "https://www.google.com";

    static void trustAll() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    System.out.println("getAcceptedIssuers =============");
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    System.out.println("checkClientTrusted =============");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    System.out.println("checkServerTrusted =============");
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    System.out.println("hostnameVerifier =============");
                    return true;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        TestApp.simpleHttpS_Connect();
    }

    private static void SSLContextTest() {
        TestApp.trustAll();
        CONSOLE_LOG.info("================= example2");
        try {
            URL url = new URL(TEST_HTTPS_URL);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            int respCode = conn.getResponseCode();
            CONSOLE_LOG.info("respCode:{}", (Object)respCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void example2() throws Exception {
        CONSOLE_LOG.info("================= example2");
        URL url = new URL(TEST_HTTPS_URL);
        HttpURLConnection connection = null;
        InetSocketAddress proxyLocation = new InetSocketAddress(proxyInfo.getHost(), proxyInfo.getPort());
        Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyLocation);
        connection = (HttpURLConnection)url.openConnection(proxy);
        String encoded = new BASE64Encoder().encodeBuffer((proxyInfo.getUser() + ":" + proxyInfo.getPassword()).getBytes()).replace("\r\n", "");
        connection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
        CONSOLE_LOG.info("connection :'{}', proxyInfo:'{}'", (Object)connection.toString(), (Object)proxyInfo);
        int respCode = connection.getResponseCode();
        CONSOLE_LOG.info("respCode:{}", (Object)respCode);
    }

    private static void simpleHttpConnect() throws Exception {
        CONSOLE_LOG.info("================= simpleHttpConnect");
        URL url = new URL(TEST_HTTP_URL);
        HttpURLConnection connection = null;
        InetSocketAddress proxyLocation = new InetSocketAddress(proxyInfo.getHost(), proxyInfo.getPort());
        Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyLocation);
        connection = (HttpURLConnection)url.openConnection(proxy);
        String encoded = new BASE64Encoder().encodeBuffer((proxyInfo.getUser() + ":" + proxyInfo.getPassword()).getBytes()).replace("\r\n", "");
        connection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
        CONSOLE_LOG.info("connection :'{}', encoded:'{}', proxyInfo:'{}'", connection.toString(), encoded, proxyInfo);
        int respCode = connection.getResponseCode();
        CONSOLE_LOG.info("respCode:{}", (Object)respCode);
    }

    private static void simpleHttpS_Connect() throws Exception {
        TestApp.trustAll();
        CONSOLE_LOG.info("================= simpleHttpS_Connect");
        URL url = new URL(TEST_HTTPS_URL);
        HttpURLConnection connection = null;
        InetSocketAddress proxyLocation = new InetSocketAddress(proxyInfo.getHost(), proxyInfo.getPort());
        Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyLocation);
        connection = (HttpURLConnection)url.openConnection(proxy);
        Authenticator.setDefault(new ProxyAuthenticator(proxyInfo));
        int respCode = connection.getResponseCode();
        CONSOLE_LOG.info("respCode:{}", (Object)respCode);
    }

    protected static void sealightsHttpClient() {
        CONSOLE_LOG.info("=================sealightsHttpClient");
        SLCustomHttpClient httpClient = new SLCustomHttpClient("empty token", proxyInfo);
        SLHttpResult<Void> res = httpClient.sendGetRequest(new SLHttpRequest<Void>("test", TEST_HTTPS_URL, Void.class));
        CONSOLE_LOG.info("recieved {}", (Object)res);
    }
}

