/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.testapp;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.slf4j.Logger;

public class ProxyAuthenticator
extends Authenticator {
    private static Logger LOG = LogFactory.getLogger(ProxyAuthenticator.class);
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger("ProxyAuthenticator");
    private ProxyInfo proxyInfo;

    public ProxyAuthenticator(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.proxyInfo.isAuthorized() && this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(this.proxyInfo.getHost()) && this.proxyInfo.getPort() == this.getRequestingPort()) {
            LOG.info("Proxy authentication was added");
            CONSOLE_LOG.info("Temporary:Proxy authentication was added");
            return new PasswordAuthentication(this.proxyInfo.getUser(), this.proxyInfo.getPassword().toCharArray());
        }
        LOG.info("Proxy does not demands authentication");
        CONSOLE_LOG.info("Temporary:Proxy does not demands authentication");
        return null;
    }
}

