/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.custom;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpCustomRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.custom.CustomHttpConnection;
import io.sealights.onpremise.agents.infra.http.utils.SSLCertificateHandler;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

public class SLCustomHttpClient
extends SLHttpClient {
    private static Logger LOG = LogFactory.getLogger(SLCustomHttpClient.class);
    private CustomHttpConnection httpConnection;
    private Map<String, String> defaultHeaders = new HashMap<String, String>();

    public SLCustomHttpClient(String token, ProxyInfo proxyInfo) {
        super(token, proxyInfo);
        SSLCertificateHandler.createCustomSSLContext();
        this.httpConnection = new CustomHttpConnection();
        LOG.debug("Created {}", (Object)this);
    }

    @Override
    public void initConnection(SLHttpRequest.RequestContentType contentType) {
        if (this.defaultHeaders.size() == 0) {
            this.defaultHeaders.put("Content-Type", this.resolveContentType(contentType));
            this.defaultHeaders.put("Accept-Charset", "utf-8");
        }
    }

    private String resolveContentType(SLHttpRequest.RequestContentType contentType) {
        switch (contentType) {
            case APPLICATION_OCTET_STREAM: {
                return "application/octet-stream";
            }
        }
        return "application/json;charset=utf-8";
    }

    @Override
    public <T> SLHttpResult<T> sendPostRequest(SLHttpRequest<T> request) {
        String body = JsonObjectMapper.toJson(request.getRequestData());
        return this.sendHttpRequest(request, body, SLHttpCustomRequest.HttpRequestMethod.POST);
    }

    @Override
    public <T> SLHttpResult<T> sendGetRequest(SLHttpRequest<T> request) {
        return this.sendHttpRequest(request, null, SLHttpCustomRequest.HttpRequestMethod.GET);
    }

    @Override
    public <T> SLHttpResult<T> sendPutRequest(SLHttpRequest<T> request) {
        return this.unsupportedMethod("put");
    }

    @Override
    public <T> SLHttpResult<T> sendDeleteRequest(SLHttpRequest<T> request) {
        return this.unsupportedMethod("delete");
    }

    private <T> SLHttpResult<T> unsupportedMethod(String method) {
        throw new UnsupportedOperationException(String.format("http %s request is not supported", method));
    }

    @Override
    public SLHttpResult.SLHttpResultVoid downloadFileRequest(String serviceTag, String fromUrl, String toFileName) {
        this.logRequestStart(serviceTag, SLHttpCustomRequest.HttpRequestMethod.GET.name(), fromUrl, null);
        SLHttpResult.SLHttpResultVoid slResult = this.httpConnection.downloadFile(fromUrl, toFileName, this.getProxyInfo());
        this.logRequestEnd(serviceTag, SLHttpCustomRequest.HttpRequestMethod.GET.name(), fromUrl, slResult, false);
        return slResult;
    }

    protected <T> SLHttpResult<T> sendHttpRequest(SLHttpRequest<T> request, String nullableBody, SLHttpCustomRequest.HttpRequestMethod requestMethod) {
        this.logRequestStart(request.getServiceTag(), requestMethod.name(), request.getUrl(), nullableBody);
        this.initConnection(request.getContentType());
        SLHttpCustomRequest customRequest = new SLHttpCustomRequest(request.getUrl(), requestMethod, this.getToken(), nullableBody, this.defaultHeaders, this.isCompressRequests());
        SLHttpResult slResult = new SLHttpResult();
        slResult = this.httpConnection.sendRequest(customRequest, this.getProxyInfo(), slResult);
        this.logRequestEnd(request.getServiceTag(), requestMethod.name(), request.getUrl(), slResult, request.isIgnoreError404());
        this.handleResponse(slResult, request.getResponseClass());
        return slResult;
    }

    @Override
    public String toString() {
        return String.format("SLCustomHttpClient [%s, httpConnection=%s, defaultHeaders=%s]", super.toString(), this.httpConnection, this.defaultHeaders);
    }

    @Generated
    public void setHttpConnection(CustomHttpConnection httpConnection) {
        this.httpConnection = httpConnection;
    }
}

