/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.custom;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;
import io.sealights.onpremise.agents.infra.http.api.SLHttpCustomRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.client.HttpExceptions;
import io.sealights.onpremise.agents.infra.http.client.SLApacheHttpClient;
import io.sealights.onpremise.agents.infra.http.utils.FileDownloadExecutor;
import io.sealights.onpremise.agents.infra.http.utils.HttpRequestResponseMapper;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

public class CustomHttpConnection {
    private static Logger LOG = LogFactory.getLogger(CustomHttpConnection.class);
    private String charset = "utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SLHttpResult<T> sendRequest(SLHttpCustomRequest request, ProxyInfo proxyInfo, SLHttpResult<T> slResult) {
        SLHttpCustomRequest.HttpRequestMethod requestMethod = request.getRequestMethod();
        HttpURLConnection connection = null;
        boolean originalFollowRedirects = HttpURLConnection.getFollowRedirects();
        try {
            URL targetUrl = new URL(request.getUrl());
            HttpURLConnection httpURLConnection = connection = this.createHttpConnection(targetUrl, proxyInfo);
            synchronized (httpURLConnection) {
                try {
                    this.setupConnectionObject(request, requestMethod, connection);
                    if (requestMethod == SLHttpCustomRequest.HttpRequestMethod.POST) {
                        HttpRequestResponseMapper.putRequestBodyToStream(request, connection.getOutputStream());
                    }
                    slResult.setStatusCode(connection.getResponseCode());
                    if (slResult.getStatusCode() == 404) {
                        throw new HttpExceptions.SLHttp404NotFoundException(slResult);
                    }
                    if (slResult.getStatusCode() >= 400) {
                        HttpRequestResponseMapper.setResponseBody(slResult, connection.getErrorStream());
                    } else {
                        HttpRequestResponseMapper.setResponseBody(slResult, connection.getInputStream());
                    }
                    SLHttpResult<T> sLHttpResult = slResult;
                    return sLHttpResult;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (HttpExceptions.SLHttp404NotFoundException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        String msg = String.format("Failed to send '%s' request to '%s'. Error: %s", new Object[]{requestMethod, request.getUrl(), e});
                        LOG.error(msg, e);
                        throw new HttpExceptions.SLHttpException(msg, slResult, e);
                    }
                }
            }
        }
        finally {
            HttpURLConnection.setFollowRedirects(originalFollowRedirects);
        }
    }

    public SLHttpResult.SLHttpResultVoid downloadFile(String fromUrl, String toFileName, ProxyInfo proxyInfo) {
        FileDownloadExecutor.FileReader reader = new FileDownloadExecutor.FileReader(){
            private HttpURLConnection connection = null;

            @Override
            public void readFile(String fromUrl, ProxyInfo proxyInfo) throws Throwable {
                URL targetUrl = new URL(fromUrl);
                this.connection = CustomHttpConnection.this.createHttpConnection(targetUrl, proxyInfo);
            }

            @Override
            public int getStatusCode() {
                try {
                    if (this.connection != null) {
                        return this.connection.getResponseCode();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Get status code with exception", e);
                }
                return -1;
            }

            @Override
            public InputStream getInputSTream() throws Throwable {
                if (this.connection != null) {
                    return this.connection.getInputStream();
                }
                return null;
            }
        };
        return FileDownloadExecutor.execute(fromUrl, toFileName, proxyInfo, reader);
    }

    protected HttpURLConnection createHttpConnection(URL targetUrl, ProxyInfo proxyInfo) throws Exception {
        HttpURLConnection connection;
        if (proxyInfo != null && !proxyInfo.isEmpty()) {
            connection = this.createHttpConnectionViaProxy(targetUrl, proxyInfo);
            LOG.info("http connection for url:'{}' via proxy:'{}'", (Object)connection.getURL(), (Object)proxyInfo);
        } else {
            connection = (HttpURLConnection)targetUrl.openConnection(Proxy.NO_PROXY);
        }
        return connection;
    }

    protected HttpURLConnection createHttpConnectionViaProxy(URL targetUrl, ProxyInfo proxyInfo) throws Exception {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyInfo.getHost(), proxyInfo.getPort()));
        if (proxyInfo.isAuthorized()) {
            throw new RuntimeException(String.format("Authorized proxy is not supported by class '%s', class '%s' should be used instead", this.getClass().getName(), SLApacheHttpClient.class.getName()));
        }
        return (HttpURLConnection)targetUrl.openConnection(proxy);
    }

    private void setupConnectionObject(SLHttpCustomRequest request, SLHttpCustomRequest.HttpRequestMethod requestMethod, HttpURLConnection connection) throws ProtocolException {
        connection.setRequestMethod(requestMethod.toString());
        if (requestMethod == SLHttpCustomRequest.HttpRequestMethod.POST) {
            connection.setDoOutput(true);
        } else if (requestMethod == SLHttpCustomRequest.HttpRequestMethod.HEAD) {
            HttpURLConnection.setFollowRedirects(false);
            connection.setRequestMethod("HEAD");
        }
        connection.setConnectTimeout(SLHttpConfiguration.getConnectionTimeoutMsec());
        connection.setReadTimeout(SLHttpConfiguration.getReadTimeoutMsec());
        if (request.getHttpHeaders() != null) {
            for (Map.Entry<String, String> httpHeader : request.getHttpHeaders().entrySet()) {
                connection.setRequestProperty(httpHeader.getKey(), httpHeader.getValue());
            }
        }
        if (request.isCompressRequestBody() && connection.getDoOutput()) {
            connection.setRequestProperty("Content-Encoding", "gzip");
        }
        if (request.getToken() != null) {
            connection.setRequestProperty("Authorization", "Bearer " + request.getToken());
        }
    }

    public String toString() {
        return String.format("(charset=%s)", this.charset);
    }

    @Generated
    public String getCharset() {
        return this.charset;
    }

    @Generated
    public void setCharset(String charset) {
        this.charset = charset;
    }
}

