/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.client;

import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.client.HttpExceptions;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import javax.net.ssl.SSLProtocolException;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SLHttpClientMockUtils {
    public static final String GOOD_EMPTY_RESPONSE = "";

    public static CloseableHttpClient mockClosebaleHttpClientWithResponse(int statusCode) {
        CloseableHttpResponse httpResponseMock = SLHttpClientMockUtils.mockCloseableHttpResponse(statusCode);
        return SLHttpClientMockUtils.mockCloseableHttpClient(httpResponseMock);
    }

    public static CloseableHttpClient mockClosebaleHttpClientWithResponseAndBody(int statusCode, String responseBody) {
        CloseableHttpResponse httpResponseMock = SLHttpClientMockUtils.mockCloseableHttpResponse(statusCode, responseBody);
        return SLHttpClientMockUtils.mockCloseableHttpClient(httpResponseMock);
    }

    public static CloseableHttpClient mockCloseableHttpClientWithException(Exception error) {
        CloseableHttpClient httpClientMock = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try {
            Mockito.when((Object)httpClientMock.execute((ClassicHttpRequest)Matchers.any(HttpUriRequest.class))).thenThrow(new Throwable[]{error});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpClientMock;
    }

    private static CloseableHttpClient mockCloseableHttpClient(CloseableHttpResponse httpResponseMock) {
        CloseableHttpClient httpClientMock = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try {
            Mockito.when((Object)httpClientMock.execute((ClassicHttpRequest)Matchers.any(HttpUriRequest.class))).thenReturn((Object)httpResponseMock);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpClientMock;
    }

    public static CloseableHttpResponse mockCloseableHttpResponse(int statusCode) {
        String responseBody = null;
        if (statusCode == 200) {
            responseBody = GOOD_EMPTY_RESPONSE;
        }
        return SLHttpClientMockUtils.mockCloseableHttpResponse(statusCode, responseBody);
    }

    public static CloseableHttpResponse mockCloseableHttpResponse(int statusCode, String responseBody) {
        BasicClassicHttpResponse mockResponse = (BasicClassicHttpResponse)Mockito.mock(BasicClassicHttpResponse.class);
        Mockito.when((Object)mockResponse.getCode()).thenReturn((Object)statusCode);
        HttpEntity httpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        if (responseBody != null) {
            Mockito.when((Object)httpEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(responseBody.getBytes()));
        } else {
            Mockito.when((Object)httpEntity.getContent()).thenReturn(null);
        }
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)httpEntity);
        return SLHttpClientMockUtils.createCloseableHttpResponse(mockResponse);
    }

    public static <T> SLHttpClient mockRetryException(String errorMsg) {
        SLHttpClient httpClientMock = (SLHttpClient)Mockito.mock(SLHttpClient.class);
        Mockito.when(httpClientMock.sendRequestRetry((SLHttpRequest)Matchers.any(), (SLHttpClient.RequestRetry)Matchers.any())).thenThrow(new Throwable[]{new HttpExceptions.SLHttpException(errorMsg)});
        return httpClientMock;
    }

    public static <T> void mockRetryResponse(SLHttpClient httpClientMock, int statusCode, SLHttpResult<T> result) {
        Mockito.when(httpClientMock.sendRequestRetry((SLHttpRequest)Matchers.any(), (SLHttpClient.RequestRetry)Matchers.any())).thenReturn(SLHttpClientMockUtils.fillResult(result, statusCode));
    }

    public static <T> void mockRetryResponse(SLHttpClient httpClientMock, int statusCode, String errorMessage, SLHttpResult<T> result) {
        Mockito.when(httpClientMock.sendRequestRetry((SLHttpRequest)Matchers.any(), (SLHttpClient.RequestRetry)Matchers.any())).thenReturn(SLHttpClientMockUtils.fillResult(result, statusCode, errorMessage));
    }

    public static CloseableHttpResponse createCloseableHttpResponse(BasicClassicHttpResponse internalResponse) throws Exception, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<CloseableHttpResponse> cl = CloseableHttpResponse.class;
        Class[] type = new Class[]{ClassicHttpResponse.class, ExecRuntime.class};
        Constructor cons = cl.getDeclaredConstructor(type);
        cons.setAccessible(true);
        return (CloseableHttpResponse)cons.newInstance(internalResponse, null);
    }

    public static RuntimeException mockBouncyCastleException() {
        RuntimeException exceptionMock = (RuntimeException)Mockito.mock(RuntimeException.class);
        Throwable causeMock1 = (Throwable)Mockito.mock(Throwable.class);
        InvalidAlgorithmParameterException causeMock2 = (InvalidAlgorithmParameterException)Mockito.mock(InvalidAlgorithmParameterException.class);
        Mockito.when((Object)causeMock1.getCause()).thenReturn((Object)causeMock2);
        Mockito.when((Object)causeMock2.getMessage()).thenReturn((Object)"parameter object not a ECParameterSpec");
        Mockito.when((Object)exceptionMock.getCause()).thenReturn((Object)causeMock1);
        return exceptionMock;
    }

    public static RuntimeException mockSslBrokenPipeCause() {
        RuntimeException exceptionMock = (RuntimeException)Mockito.mock(RuntimeException.class);
        Throwable causeMock1 = (Throwable)Mockito.mock(Throwable.class);
        SSLProtocolException causeMock2 = (SSLProtocolException)Mockito.mock(SSLProtocolException.class);
        Mockito.when((Object)causeMock1.getCause()).thenReturn((Object)causeMock2);
        Mockito.when((Object)causeMock2.getMessage()).thenReturn((Object)"Broken pipe");
        Mockito.when((Object)exceptionMock.getCause()).thenReturn((Object)causeMock1);
        return exceptionMock;
    }

    private static <T> SLHttpResult<T> fillResult(SLHttpResult<T> result, int statusCode, String errorMessage) {
        result.setStatusCode(statusCode);
        if (!result.isStatusCodeOk()) {
            result.setStatusMessage(errorMessage);
        }
        return result;
    }

    private static <T> SLHttpResult<T> fillResult(SLHttpResult<T> result, int statusCode) {
        result.setStatusCode(statusCode);
        if (!result.isStatusCodeOk()) {
            result.setStatusMessage(SLHttpClientMockUtils.createFakeException(result).getMessage());
        }
        return result;
    }

    private static HttpExceptions.SLHttpException createFakeException(SLHttpResult<?> result) {
        if (result.getStatusCode() == 404) {
            return new HttpExceptions.SLHttp404NotFoundException(result);
        }
        return new HttpExceptions.SLHttpException(result);
    }
}

