/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.client;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.client.AuthorizationMode;
import io.sealights.onpremise.agents.infra.http.client.ExceptionMatchers;
import io.sealights.onpremise.agents.infra.http.client.HttpRequestConfigurator;
import io.sealights.onpremise.agents.infra.http.client.SecurityProvidersOrganizer;
import io.sealights.onpremise.agents.infra.http.utils.FileDownloadExecutor;
import java.io.InputStream;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;

public class FileDownloadReader
implements FileDownloadExecutor.FileReader {
    private final CloseableHttpClient httpClient;
    private final HttpRequestConfigurator requestConfigurator;
    private final SecurityProvidersOrganizer securityProvidersOrganizer;
    private CloseableHttpResponse response = null;

    public FileDownloadReader(CloseableHttpClient httpClient, HttpRequestConfigurator requestConfigurator, SecurityProvidersOrganizer securityProvidersOrganizer) {
        this.httpClient = httpClient;
        this.requestConfigurator = requestConfigurator;
        this.securityProvidersOrganizer = securityProvidersOrganizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFile(String fromUrl, ProxyInfo proxyInfo) throws Throwable {
        block6: {
            try {
                HttpGet httpGet = new HttpGet(fromUrl);
                this.requestConfigurator.configureRequest(httpGet, AuthorizationMode.UNAUTHORIZED);
                this.response = this.httpClient.execute(httpGet);
            }
            catch (Throwable e) {
                if (ExceptionMatchers.isBouncyCastleProviderException(e)) {
                    this.securityProvidersOrganizer.moveSunECProviderOnTop();
                    this.readFile(fromUrl, proxyInfo);
                    break block6;
                }
                throw e;
            }
            finally {
                this.securityProvidersOrganizer.restoreOriginalOrder();
            }
        }
    }

    @Override
    public int getStatusCode() {
        if (this.response != null) {
            return this.response.getCode();
        }
        return -1;
    }

    @Override
    public InputStream getInputSTream() throws Throwable {
        if (this.response != null && this.response.getEntity() != null) {
            return this.response.getEntity().getContent();
        }
        return null;
    }
}

