/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.client;

import java.security.InvalidAlgorithmParameterException;
import javax.net.ssl.SSLProtocolException;

public class ExceptionMatchers {
    private static final SslBrokenPipeExceptionMatcher BROKEN_PIPE_ERROR_MATCHER = new SslBrokenPipeExceptionMatcher();
    private static final BouncyCastleProviderExceptionMatcher BOUNCY_CASTLE_ERROR_MATCHER = new BouncyCastleProviderExceptionMatcher();

    public static boolean isSslBrokenPipeException(Throwable e) {
        return BROKEN_PIPE_ERROR_MATCHER.execute(e);
    }

    public static boolean isBouncyCastleProviderException(Throwable e) {
        return BOUNCY_CASTLE_ERROR_MATCHER.execute(e);
    }

    static abstract class RecursiveExceptionMatcher {
        RecursiveExceptionMatcher() {
        }

        public boolean execute(Throwable exception) {
            if (this.match(exception)) {
                return true;
            }
            Throwable cause = exception.getCause();
            if (cause != null) {
                return this.execute(cause);
            }
            return false;
        }

        protected boolean match(Throwable exception) {
            return this.matchMessage(exception) && this.matchExceptionType(exception);
        }

        protected abstract boolean matchMessage(Throwable var1);

        protected abstract boolean matchExceptionType(Throwable var1);
    }

    public static class SslBrokenPipeExceptionMatcher
    extends RecursiveExceptionMatcher {
        public static final String SSL_BROKEN_PIPE_ERROR_MSG = "Broken pipe";

        @Override
        protected boolean matchMessage(Throwable exception) {
            String exceptionMessage = exception.getMessage();
            return exceptionMessage != null && exceptionMessage.startsWith(SSL_BROKEN_PIPE_ERROR_MSG);
        }

        @Override
        protected boolean matchExceptionType(Throwable exception) {
            return exception instanceof SSLProtocolException;
        }
    }

    public static class BouncyCastleProviderExceptionMatcher
    extends RecursiveExceptionMatcher {
        public static final String BOUNCY_CASTLE_ERROR_MSG = "parameter object not a ECParameterSpec";

        @Override
        protected boolean matchMessage(Throwable exception) {
            return BOUNCY_CASTLE_ERROR_MSG.equals(exception.getMessage());
        }

        @Override
        protected boolean matchExceptionType(Throwable exception) {
            return exception instanceof InvalidAlgorithmParameterException;
        }
    }
}

