/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import lombok.Generated;

public class SLHttpRequest<T> {
    private String serviceTag;
    private String url;
    private Object requestData;
    private Class<T> responseClass;
    private boolean ignoreError404;
    private RequestContentType contentType = RequestContentType.APPLICATION_JSON;

    public SLHttpRequest(String url) {
        this.url = url;
    }

    public SLHttpRequest(String serviceTag, String url, Class<T> responseClass, boolean ignoreError404) {
        this(serviceTag, url, responseClass);
        this.ignoreError404 = ignoreError404;
    }

    public SLHttpRequest(String serviceTag, String url, Object requestData, Class<T> responseClass) {
        this(serviceTag, url, responseClass);
        this.requestData = requestData;
    }

    public SLHttpRequest(String serviceTag, String url, Object requestData, Class<T> responseClass, RequestContentType contentType) {
        this(serviceTag, url, responseClass);
        this.requestData = requestData;
        this.contentType = contentType;
    }

    public SLHttpRequest(String serviceTag, String url, Class<T> responseClass) {
        this.serviceTag = serviceTag;
        this.url = url;
        this.responseClass = responseClass;
    }

    public String toString() {
        return String.format("SLHttpRequest {serviceTag=%s, url=%s, requestData=%s, responseClass=%s, ignoreError404=%s}", this.serviceTag, this.url, this.requestData, this.responseClass, this.ignoreError404);
    }

    @Generated
    public String getServiceTag() {
        return this.serviceTag;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Object getRequestData() {
        return this.requestData;
    }

    @Generated
    public Class<T> getResponseClass() {
        return this.responseClass;
    }

    @Generated
    public boolean isIgnoreError404() {
        return this.ignoreError404;
    }

    @Generated
    public RequestContentType getContentType() {
        return this.contentType;
    }

    @Generated
    public void setServiceTag(String serviceTag) {
        this.serviceTag = serviceTag;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setRequestData(Object requestData) {
        this.requestData = requestData;
    }

    @Generated
    public void setResponseClass(Class<T> responseClass) {
        this.responseClass = responseClass;
    }

    @Generated
    public void setIgnoreError404(boolean ignoreError404) {
        this.ignoreError404 = ignoreError404;
    }

    @Generated
    public void setContentType(RequestContentType contentType) {
        this.contentType = contentType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SLHttpRequest)) {
            return false;
        }
        SLHttpRequest other = (SLHttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIgnoreError404() != other.isIgnoreError404()) {
            return false;
        }
        String this$serviceTag = this.getServiceTag();
        String other$serviceTag = other.getServiceTag();
        if (this$serviceTag == null ? other$serviceTag != null : !this$serviceTag.equals(other$serviceTag)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Object this$requestData = this.getRequestData();
        Object other$requestData = other.getRequestData();
        if (this$requestData == null ? other$requestData != null : !this$requestData.equals(other$requestData)) {
            return false;
        }
        Class<T> this$responseClass = this.getResponseClass();
        Class<T> other$responseClass = other.getResponseClass();
        if (this$responseClass == null ? other$responseClass != null : !this$responseClass.equals(other$responseClass)) {
            return false;
        }
        RequestContentType this$contentType = this.getContentType();
        RequestContentType other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !((Object)((Object)this$contentType)).equals((Object)other$contentType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SLHttpRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIgnoreError404() ? 79 : 97);
        String $serviceTag = this.getServiceTag();
        result = result * 59 + ($serviceTag == null ? 43 : $serviceTag.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Object $requestData = this.getRequestData();
        result = result * 59 + ($requestData == null ? 43 : $requestData.hashCode());
        Class<T> $responseClass = this.getResponseClass();
        result = result * 59 + ($responseClass == null ? 43 : $responseClass.hashCode());
        RequestContentType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)((Object)$contentType)).hashCode());
        return result;
    }

    @Generated
    public SLHttpRequest() {
    }

    @Generated
    public SLHttpRequest(String serviceTag, String url, Object requestData, Class<T> responseClass, boolean ignoreError404, RequestContentType contentType) {
        this.serviceTag = serviceTag;
        this.url = url;
        this.requestData = requestData;
        this.responseClass = responseClass;
        this.ignoreError404 = ignoreError404;
        this.contentType = contentType;
    }

    public static enum RequestContentType {
        APPLICATION_JSON,
        APPLICATION_OCTET_STREAM,
        MULTIPART_FORM_DATA;

    }
}

