/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;

public class SLHttpConfiguration {
    private static final int SECOND = 1000;
    public static final int DEFAULT_MAX_ATTEMPTS = 5;
    public static final int DEFAULT_ATTEMPT_INTERVAL = 5000;
    public static final int DEFAULT_MAX_PRINT_BODY_SIZE = 1024;
    public static final int DEFAULT_CONNECTION_TIMEOUT_MSEC = 10000;
    public static final int DEFAULT_READ_TIMEOUT_MSEC = 20000;

    public static int getConnectionTimeoutMsec() {
        return SystemPropertiesHelper.getIntProperty("sl.connectionTimeoutMS", 10000);
    }

    public static int getReadTimeoutMsec() {
        return SystemPropertiesHelper.getIntProperty("sl.readTimeoutMS", 20000);
    }

    public static int getMaxAttempts() {
        return SystemPropertiesHelper.getIntProperty("sl.httpMaxAttempts", 5);
    }

    public static int getAttemptInterval() {
        return SystemPropertiesHelper.getIntProperty("sl.httpAttemptInterval", 5000);
    }

    public static int getPrintableBodySize() {
        return SystemPropertiesHelper.getIntProperty("sl.maxPrintBodySize", 1024);
    }

    public static String getHttpClientRootLog() {
        return SystemPropertiesHelper.getStrPropertyIfExists("sl.httpDebugLog");
    }

    public static boolean isUseCustomClient() {
        return SystemPropertiesHelper.getBoolProperty("sl.useCustomClient");
    }

    public static String getRequestLogsLocation() {
        return SystemPropertiesHelper.getStrProperty("sl.httpRequestsLogLocation");
    }

    public static String getProxyServerHost() {
        return SystemPropertiesHelper.getStrProperty("sl.proxyServerHost");
    }

    public static Integer getProxyServerPort() {
        return SystemPropertiesHelper.getIntObjectProperty("sl.proxyServerPort");
    }

    public static String asString() {
        return String.format("connectionTimeoutMsec=%s, readTimeoutMsec=%s,maxAttempts=%s, attemptInterval=%s, printableBodySize=%s, httpClientRootLog=%s, useCustomClient=%s,proxyServerHost=%s, proxyServerPort=%s", SLHttpConfiguration.getConnectionTimeoutMsec(), SLHttpConfiguration.getReadTimeoutMsec(), SLHttpConfiguration.getMaxAttempts(), SLHttpConfiguration.getAttemptInterval(), SLHttpConfiguration.getPrintableBodySize(), SLHttpConfiguration.getHttpClientRootLog(), SLHttpConfiguration.isUseCustomClient(), SLHttpConfiguration.getProxyServerHost(), SLHttpConfiguration.getProxyServerPort());
    }

    private SLHttpConfiguration() {
    }
}

