/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClientFactory;
import io.sealights.onpremise.agents.infra.http.client.SLApacheHttpClient;
import io.sealights.onpremise.agents.infra.http.custom.SLCustomHttpClient;
import io.sealights.onpremise.agents.java.agent.test.infra.junit.JUnitTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SLHttpClientFactoryTest
extends JUnitTestBase {
    private static final String DEFAULT_CLIENT_CLASS = SLApacheHttpClient.class.getName();
    private static final String CUSTOM_CLIENT_CLASS = SLCustomHttpClient.class.getName();
    private static final String WRONG_CLASS_MSG = "Wrong client class ";
    private static final String CLIENT_INSTANCE_NOT_CREATED_MSG = "client instance was not created";

    @Before
    public void setup() {
        this.reset();
    }

    @After
    public void tearDown() {
        this.reset();
    }

    @Test
    public void getDefaultHttpClient_noPropertyDefined_defaultClientCreated() {
        this.createAndAssertClientInstance(null, DEFAULT_CLIENT_CLASS);
    }

    @Test
    public void getDefaultHttpClientTwice_noPropertyDefined_defaultClientCreatedOnce() {
        SLHttpClient client1 = this.createAndAssertClientInstance(null, DEFAULT_CLIENT_CLASS);
        SLHttpClient client2 = this.createAndAssertClientInstance(null, DEFAULT_CLIENT_CLASS);
        Assert.assertEquals((Object)client1, (Object)client2);
    }

    @Test
    public void getDefaultHttpClient_customClientClassPropertyTrue_customClientCreated() {
        SystemPropertiesHelper.setProperty("sl.useCustomClient", true);
        this.createAndAssertClientInstance(null, CUSTOM_CLIENT_CLASS);
    }

    @Test
    public void getDefaultHttpClientTwice_customClientCreatedTwice() {
        SystemPropertiesHelper.setProperty("sl.useCustomClient", true);
        SLHttpClient client1 = this.createAndAssertClientInstance(null, CUSTOM_CLIENT_CLASS);
        SLHttpClient client2 = this.createAndAssertClientInstance(null, CUSTOM_CLIENT_CLASS);
        Assert.assertNotEquals((Object)client1, (Object)client2);
    }

    @Test
    public void getDefaultHttpClient_customClientClassPropertyFalse_defaultClientCreated() {
        SystemPropertiesHelper.setProperty("sl.useCustomClient", false);
        this.createAndAssertClientInstance(null, DEFAULT_CLIENT_CLASS);
    }

    @Test
    public void getDefaultHttpClient_customPropertyDefinedUnauthorizedProxy_customClientCreated() {
        System.setProperty("sl.useCustomClient", "true");
        this.createAndAssertClientInstance(new ProxyInfo("username:password"), CUSTOM_CLIENT_CLASS);
    }

    @Test
    public void getDefaultHttpClient_customPropertyDefinedAuthorizedProxy_defaultClientCreated() {
        System.setProperty("sl.useCustomClient", "true");
        this.createAndAssertClientInstance(new ProxyInfo("username:password@proxy-host.com:8080"), DEFAULT_CLIENT_CLASS);
    }

    @Test
    public void getSLApacheHttpClientAndGetDefaultHttpClient_customPropertyDefined_defaultClientCreatedOnSecondCall() {
        System.setProperty("sl.useCustomClient", "true");
        SLApacheHttpClient client1 = SLHttpClientFactory.getSLApacheHttpClient("eyJhbGciOiJSUzUxMiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJodHRwczovL0RFVi1OYWRhdi5hdXRoLnNlYWxpZ2h0cy5pby8iLCJqd3RpZCI6IkRFVi1OYWRhdixpLTI0OWY0ZWU0LEFQSUdXLWNhOWYyOWI4LWZkNDctNDAzMi04M2UzLTUxYzQ4YjEzNTgyOSwxNDc5OTE5MjMxMjMyIiwic3ViamVjdCI6IlNlYUxpZ2h0c0BhZ2VudCIsImF1ZGllbmNlIjpbImFnZW50cyJdLCJ4LXNsLXJvbGUiOiJhZ2VudCIsIngtc2wtc2VydmVyIjoiaHR0cHM6Ly9ERVYtTmFkYXYtZ3cuc2VhbGlnaHRzLmNvL2FwaSIsInNsX2ltcGVyX3N1YmplY3QiOiIiLCJpYXQiOjE0Nzk5MTkyMzF9.B2P3hLb7m0N0iB73j2SRWq5neGztEQWdV5InwaFJMRt5UF5sGHfc4ICrWz_2lb9sOYlNsU5LMygl1ubs51prfKS5nwCJ94iHahy4rYFxFkjXCYz1GOXawqwT-_pCS-_pwI6f9LFpVIHipxu3JOyY91dv_UDGU_eVIrCAaPBuJsZyrzNvvq2GoDW1-zh_KnV8MdhBPMStpgqvlAOiqy_UXlxdUVQI-iRJasm3tFkADzr3XUfE_GWlTRo8vAaZ8QWI_WNc6LLU0XLkvl9YCE7-hXGSLKLmugWi8VIHIn5YJPFKoXzOz2_Q54uAg5MOaZWjsDZl3Ab66pkggZkrRikISw7hWksCTOMY7VxB96kdsrJZiHlC4ifI68SfN0RkgokVnEw8FYzVnnwzBI9-TypFJE-rvmn3HFvaUp77CRohrPrNy7HmRg45dqxvGgwuaDce5aCMQa_KiVSIeBxA95siuENjltcd3LYbK_UWTvLRK7yJF-RC-ub1V2EFzRnXbn6MUTR8uTUZKuk2FebDE88_FJ-GQIafLqYgBi6fRenvobeNacTVG3_H9msU_cVlGDwYBVR_Jg_E5u0uU8ppfccUj7zipUth0K9f4I_mDdYCo9FfYpFmU4jAtmQVMFVXzXSovbYQAgFq6MlI1aixynhfU61B0PzYD_Tgs47nnJdWL6s", null);
        Assert.assertNotNull((String)CLIENT_INSTANCE_NOT_CREATED_MSG, (Object)client1);
        Assert.assertEquals((String)WRONG_CLASS_MSG, (Object)DEFAULT_CLIENT_CLASS, (Object)client1.getClass().getName());
        SLHttpClient client2 = this.createAndAssertClientInstance(null, CUSTOM_CLIENT_CLASS);
        Assert.assertNotEquals((Object)client1, (Object)client2);
    }

    private SLHttpClient createAndAssertClientInstance(ProxyInfo proxyInfo, String expectedClassName) {
        SLHttpClient client = SLHttpClientFactory.getDefaultHttpClient("eyJhbGciOiJSUzUxMiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJodHRwczovL0RFVi1OYWRhdi5hdXRoLnNlYWxpZ2h0cy5pby8iLCJqd3RpZCI6IkRFVi1OYWRhdixpLTI0OWY0ZWU0LEFQSUdXLWNhOWYyOWI4LWZkNDctNDAzMi04M2UzLTUxYzQ4YjEzNTgyOSwxNDc5OTE5MjMxMjMyIiwic3ViamVjdCI6IlNlYUxpZ2h0c0BhZ2VudCIsImF1ZGllbmNlIjpbImFnZW50cyJdLCJ4LXNsLXJvbGUiOiJhZ2VudCIsIngtc2wtc2VydmVyIjoiaHR0cHM6Ly9ERVYtTmFkYXYtZ3cuc2VhbGlnaHRzLmNvL2FwaSIsInNsX2ltcGVyX3N1YmplY3QiOiIiLCJpYXQiOjE0Nzk5MTkyMzF9.B2P3hLb7m0N0iB73j2SRWq5neGztEQWdV5InwaFJMRt5UF5sGHfc4ICrWz_2lb9sOYlNsU5LMygl1ubs51prfKS5nwCJ94iHahy4rYFxFkjXCYz1GOXawqwT-_pCS-_pwI6f9LFpVIHipxu3JOyY91dv_UDGU_eVIrCAaPBuJsZyrzNvvq2GoDW1-zh_KnV8MdhBPMStpgqvlAOiqy_UXlxdUVQI-iRJasm3tFkADzr3XUfE_GWlTRo8vAaZ8QWI_WNc6LLU0XLkvl9YCE7-hXGSLKLmugWi8VIHIn5YJPFKoXzOz2_Q54uAg5MOaZWjsDZl3Ab66pkggZkrRikISw7hWksCTOMY7VxB96kdsrJZiHlC4ifI68SfN0RkgokVnEw8FYzVnnwzBI9-TypFJE-rvmn3HFvaUp77CRohrPrNy7HmRg45dqxvGgwuaDce5aCMQa_KiVSIeBxA95siuENjltcd3LYbK_UWTvLRK7yJF-RC-ub1V2EFzRnXbn6MUTR8uTUZKuk2FebDE88_FJ-GQIafLqYgBi6fRenvobeNacTVG3_H9msU_cVlGDwYBVR_Jg_E5u0uU8ppfccUj7zipUth0K9f4I_mDdYCo9FfYpFmU4jAtmQVMFVXzXSovbYQAgFq6MlI1aixynhfU61B0PzYD_Tgs47nnJdWL6s", proxyInfo);
        Assert.assertNotNull((String)CLIENT_INSTANCE_NOT_CREATED_MSG, (Object)client);
        Assert.assertEquals((String)WRONG_CLASS_MSG, (Object)expectedClassName, (Object)client.getClass().getName());
        return client;
    }

    private void reset() {
        System.clearProperty("sl.useCustomClient");
        SLHttpClientFactory.resetForTestsOnly();
    }
}

