/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.http.api.HttpClientLogFormatter;
import io.sealights.onpremise.agents.infra.http.api.HttpRequestLogger;
import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.client.HttpExceptions;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenTruncated;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.infra.utils.threads.ThreadUtils;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class SLHttpClient {
    private static Logger LOG = LogFactory.getLogger(SLHttpClient.class);
    private String token;
    private ProxyInfo proxyInfo;
    private boolean compressRequests;

    public SLHttpClient(String token, ProxyInfo proxyInfo) {
        this.token = token;
        this.proxyInfo = proxyInfo;
        LOG.info("Created {}", (Object)this.getClass().getSimpleName());
    }

    public <T> SLHttpResult<T> sendRequestRetry(SLHttpRequest<T> request, RequestRetry<T> retry) {
        return new RetriesExecutor(this).sendRequestWithRetries(request, retry);
    }

    public <T> SLHttpResult<T> sendPostRetry(SLHttpRequest<T> request) {
        return this.sendRequestRetry(request, new RequestRetry<T>(){

            @Override
            public SLHttpResult<T> execute(SLHttpRequest<T> request) {
                return SLHttpClient.this.sendPostRequest(request);
            }
        });
    }

    public <T> SLHttpResult<T> sendGetRetry(SLHttpRequest<T> request) {
        return this.sendRequestRetry(request, new RequestRetry<T>(){

            @Override
            public SLHttpResult<T> execute(SLHttpRequest<T> request) {
                return SLHttpClient.this.sendGetRequest(request);
            }
        });
    }

    public <T> SLHttpResult<T> sendDeleteRetry(SLHttpRequest<T> request) {
        return this.sendRequestRetry(request, new RequestRetry<T>(){

            @Override
            public SLHttpResult<T> execute(SLHttpRequest<T> request) {
                return SLHttpClient.this.sendDeleteRequest(request);
            }
        });
    }

    public <T> void handleResponse(SLHttpResult<T> httpResult, Class<T> responseClass) {
        String body = httpResult.getBody();
        if (httpResult.isStatusCodeOk()) {
            if (!(body == null || responseClass.equals(Void.class) || body.equals("") || body.equals("{}"))) {
                httpResult.setResponseObject(JsonObjectMapper.toObject(body, responseClass));
            }
            return;
        }
        if (StringUtils.isNotEmpty(body)) {
            httpResult.setStatusMessage(body);
        }
        if (httpResult.getStatusCode() == 404) {
            throw new HttpExceptions.SLHttp404NotFoundException(httpResult);
        }
        throw new HttpExceptions.SLHttpException(httpResult);
    }

    protected void logRequestStart(String serviceTag, String method, String url, String nullableBody) {
        LOG.info(HttpClientLogFormatter.logRequestStartMsg(serviceTag, method, url, this.token, nullableBody));
        if (StringUtils.isNotEmpty(nullableBody)) {
            HttpRequestLogger.logHttpRequest(method, url, nullableBody);
        }
    }

    protected <T> void logRequestEnd(String serviceTag, String method, String url, SLHttpResult<T> slResult, boolean ignoreError) {
        if (slResult.isStatusCodeOk() || ignoreError) {
            LOG.info(HttpClientLogFormatter.logRequestEndMsg(serviceTag, method, url, slResult));
        } else {
            LOG.error(HttpClientLogFormatter.logRequestEndMsg(serviceTag, method, url, slResult));
        }
    }

    public abstract void initConnection(SLHttpRequest.RequestContentType var1);

    public abstract <T> SLHttpResult<T> sendPostRequest(SLHttpRequest<T> var1);

    public abstract <T> SLHttpResult<T> sendPutRequest(SLHttpRequest<T> var1);

    public abstract <T> SLHttpResult<T> sendGetRequest(SLHttpRequest<T> var1);

    public abstract <T> SLHttpResult<T> sendDeleteRequest(SLHttpRequest<T> var1);

    public abstract SLHttpResult.SLHttpResultVoid downloadFileRequest(String var1, String var2, String var3);

    public boolean isFatalError(Throwable e) {
        return e instanceof VirtualMachineError;
    }

    public String toString() {
        return String.format("token=%s, proxyInfo=%s, compressRequests=%s, httpConfiguration:(%s)", TokenTruncated.truncate(this.token), this.proxyInfo, this.compressRequests, SLHttpConfiguration.asString());
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    @Generated
    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
    }

    @Generated
    public boolean isCompressRequests() {
        return this.compressRequests;
    }

    @Generated
    public void setCompressRequests(boolean compressRequests) {
        this.compressRequests = compressRequests;
    }

    static class RetriesExecutor {
        private SLHttpClient httpClient;

        <T> SLHttpResult<T> sendRequestWithRetries(SLHttpRequest<T> request, RequestRetry<T> retry) {
            this.httpClient.initConnection(request.getContentType());
            int currentAttempt = 1;
            int maxAttempts = SLHttpConfiguration.getMaxAttempts();
            int delay = SLHttpConfiguration.getAttemptInterval();
            Throwable lastError = null;
            while (true) {
                try {
                    if (currentAttempt > 1) {
                        ThreadUtils.sleepMillis(delay);
                    }
                    LOG.debug("[To {}] - attempt '#{}' out of '{}, url:'{}'", request.getServiceTag(), currentAttempt, maxAttempts, request.getUrl());
                    return retry.execute(request);
                }
                catch (Throwable e) {
                    SLHttpResult<T> result;
                    if (this.httpClient.isFatalError(e)) {
                        this.rethrowOnFatalError(request, e);
                    }
                    if (e instanceof HttpExceptions.SLHttpException && (result = this.createResultIfNotRecoverableError((HttpExceptions.SLHttpException)e, retry)) != null) {
                        return result;
                    }
                    lastError = e;
                    if (++currentAttempt <= maxAttempts) continue;
                    if (lastError instanceof HttpExceptions.SLHttpException) {
                        throw (HttpExceptions.SLHttpException)lastError;
                    }
                    throw new HttpExceptions.SLHttpException(String.format("All %s attempts to send the request to the server have failed. Last error: %s", maxAttempts, lastError.toString()), lastError);
                }
                break;
            }
        }

        private void rethrowOnFatalError(SLHttpRequest<?> request, Throwable e) {
            String msg = String.format("Failed to send '%s' request to '%s' due to %s", request.getServiceTag(), request.getUrl(), e.toString());
            LOG.error(msg, e);
            throw new HttpExceptions.SLHttpException(msg, e);
        }

        private <T> SLHttpResult<T> createResultIfNotRecoverableError(HttpExceptions.SLHttpException e, RequestRetry<T> retry) {
            SLHttpResult<?> result = e.getResult();
            if (!retry.isRecoverableError(result.getStatusCode())) {
                return result;
            }
            return null;
        }

        @Generated
        public RetriesExecutor(SLHttpClient httpClient) {
            this.httpClient = httpClient;
        }
    }

    public static abstract class RequestRetry<T> {
        public abstract SLHttpResult<T> execute(SLHttpRequest<T> var1);

        public boolean isRecoverableError(int httpCode) {
            switch (httpCode) {
                case 401: 
                case 405: {
                    return false;
                }
            }
            return true;
        }
    }
}

