/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"UnitTest"})
public class ProxyInfoTest {
    private static final int PORT = 8080;
    private static final String URL = "AAA";
    private static final String USER = "username";
    private static final String PASSWORD = "password";
    private static final String HOST = "proxy-host.com";
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTP_URL = "http://AAA";
    private static final String URL_WITH_USER_PASSWORD = "username:password@proxy-host.com";
    private static final String[] VALID_VALUES_NOT_AUTHORIZED_HTTP = new String[]{"proxy-host.com:8080", "proxy-host.com:8080", "http://proxy-host.com:8080", "http://proxy-host.com"};
    private static final String[] VALID_VALUES_NOT_AUTHORIZED_HTTPS = new String[]{"https://proxy-host.com:8080", "https://proxy-host.com"};
    private static final String[] VALID_VALUES_AUTHORIZED = new String[]{"username:password@proxy-host.com:8080", "username:password@proxy-host.com"};
    private static final String[] INVALID_VALUES = new String[]{"http:/", "http://", "http:abc.com", "http"};

    @Test
    public void createProxyInfo_configValueNoProtocol_shouldContainHostAndPort() {
        ProxyInfo proxyInfo = new ProxyInfo(String.format("%s:%s", URL, 8080));
        this.assertPortValue(proxyInfo, 8080);
        this.assertHostValue(proxyInfo, URL);
    }

    @Test
    public void createProxyInfo_configValueNoProtocolNoPort_shouldContainHostAndDefaultPort() {
        ProxyInfo proxyInfo = new ProxyInfo(URL);
        this.assertPortValue(proxyInfo, 80);
        this.assertHostValue(proxyInfo, URL);
    }

    @Test
    public void createProxyInfo_configValueWithProtocol_shouldContainHostAndPort() {
        ProxyInfo proxyInfo = new ProxyInfo(String.format("%s:%s", HTTP_URL, 8080));
        System.out.println(proxyInfo);
        this.assertPortValue(proxyInfo, 8080);
        this.assertHostValue(proxyInfo, URL);
    }

    @Test
    public void createProxyInfo_configValueWithHttpProtocolNoPort_shouldContainHostAndDefaultPort() {
        ProxyInfo proxyInfo = new ProxyInfo(HTTP_URL);
        this.assertPortValue(proxyInfo, 80);
        this.assertHostValue(proxyInfo, URL);
        this.assertProtocolValue(proxyInfo, "http");
    }

    @Test
    public void createProxyInfo_validNotAuthValuesHttp_validProxyInfoCreated() {
        for (String value : VALID_VALUES_NOT_AUTHORIZED_HTTP) {
            ProxyInfo proxyInfo = new ProxyInfo(value);
            Assert.assertFalse((boolean)proxyInfo.isAuthorized(), (String)"Not authorized proxyInfo is expected");
            this.assertPortValue(proxyInfo, -1);
            this.assertHostValue(proxyInfo, HOST);
            this.assertUserValue(proxyInfo, "");
            this.assertPasswordValue(proxyInfo, "");
            this.assertProtocolValue(proxyInfo, "http");
        }
    }

    @Test
    public void createProxyInfo_validNotAuthValuesHttps_validProxyInfoCreated() {
        for (String value : VALID_VALUES_NOT_AUTHORIZED_HTTPS) {
            ProxyInfo proxyInfo = new ProxyInfo(value);
            Assert.assertFalse((boolean)proxyInfo.isAuthorized(), (String)"Not authorized proxyInfo is expected");
            this.assertPortValue(proxyInfo, -1);
            this.assertHostValue(proxyInfo, HOST);
            this.assertUserValue(proxyInfo, "");
            this.assertPasswordValue(proxyInfo, "");
            this.assertProtocolValue(proxyInfo, "https");
        }
    }

    @Test
    public void createProxyInfo_validAuthorizedValues_validProxyInfoCreated() {
        for (String value : VALID_VALUES_AUTHORIZED) {
            ProxyInfo proxyInfo = new ProxyInfo(value);
            Assert.assertTrue((boolean)proxyInfo.isAuthorized(), (String)"Authorized proxyInfo is expected");
            this.assertPortValue(proxyInfo, -1);
            this.assertHostValue(proxyInfo, HOST);
            this.assertUserValue(proxyInfo, USER);
            this.assertPasswordValue(proxyInfo, PASSWORD);
        }
    }

    @Test
    public void createProxyInfo_invalidConfigValueFormat_shouldThrowRuntimeException() {
        for (String value : INVALID_VALUES) {
            try {
                new ProxyInfo(value);
                Assert.fail((String)String.format("RuntimeException is expected on invalid proxy value '%s', but is was not thrown", value));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void createProxyInfoWithUserPasswordPort_validProxyInfoCreated() {
        ProxyInfo proxyInfo = new ProxyInfo(String.format("%s%s:%s", HTTP_PREFIX, URL_WITH_USER_PASSWORD, 8080));
        this.assertPortValue(proxyInfo, 8080);
        this.assertHostValue(proxyInfo, HOST);
    }

    @Test
    public void createProxyInfoWithUserPasswordNoPort_validProxyInfoCreatedWithDefaultPort() {
        ProxyInfo proxyInfo = new ProxyInfo("http://username:password@proxy-host.com");
        this.assertPortValue(proxyInfo, 80);
        this.assertHostValue(proxyInfo, HOST);
    }

    @Test
    public void createProxyInfo_emptyConfigValue_shouldBeEmptyProxy() {
        ProxyInfo proxyInfo = new ProxyInfo("");
        Assert.assertTrue((boolean)proxyInfo.isEmpty(), (String)"Empty proxy is expected, but not empty was created ");
    }

    @Test
    public void createEmptyProxyInfo_toStringDoesNotPrintUrlInfo() {
        ProxyInfo proxyInfo = (ProxyInfo)Mockito.spy((Object)new ProxyInfo(""));
        ((ProxyInfo)Mockito.verify((Object)proxyInfo, (VerificationMode)Mockito.never())).getUrlString();
    }

    @Test
    public void createProxyInfo_nullConfigValue_shouldBeEmptyProxy() {
        ProxyInfo proxyInfo = new ProxyInfo(null);
        Assert.assertTrue((boolean)proxyInfo.isEmpty(), (String)"Empty proxy is expected, but not empty was created ");
    }

    private void assertHostValue(ProxyInfo proxyInfo, String expected) {
        Assert.assertEquals((String)proxyInfo.getHost(), (String)expected, (String)"Wrong host value: ");
    }

    private void assertPortValue(ProxyInfo proxyInfo, int expected) {
        if (expected == -1) {
            Assert.assertTrue((proxyInfo.getPort() > 0 ? 1 : 0) != 0, (String)"Positive port value is expected. ");
        } else {
            Assert.assertEquals((int)proxyInfo.getPort(), (int)expected, (String)"Wrong port value: ");
        }
    }

    private void assertUserValue(ProxyInfo proxyInfo, String expected) {
        Assert.assertEquals((String)proxyInfo.getUser(), (String)expected, (String)"Wrong user value: ");
    }

    private void assertPasswordValue(ProxyInfo proxyInfo, String expected) {
        Assert.assertEquals((String)proxyInfo.getPassword(), (String)expected, (String)"Wrong password value: ");
    }

    private void assertProtocolValue(ProxyInfo proxyInfo, String expected) {
        Assert.assertEquals((String)proxyInfo.getProtocol(), (String)expected, (String)"Wrong protocol value: ");
    }

    @Test
    public void createProxyInfo_configValueWithSlashInTheEnd_shouldContainValidPort() {
        ProxyInfo proxyInfo = new ProxyInfo(String.format("%s:%s/", HTTP_URL, 8080));
        Assert.assertEquals((int)proxyInfo.getPort(), (int)8080);
    }

    @Test
    public void createProxyInfo_configValueWithSlashInTheEndWithoutPort_shouldContainValidURL() {
        String expected = String.format("%s:%s", HTTP_URL, 80);
        ProxyInfo proxyInfo = new ProxyInfo(String.format("%s/", HTTP_URL));
        Assert.assertEquals((String)proxyInfo.getUrlString(), (String)expected);
    }
}

