/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.http.api.HttpRequestLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"UnitTest"})
public class HttpRequestLoggerTest {
    private static final String FILE_ROOT = "src/test/resources/httpLogs";
    private static final String SMAPLE_URL = "https://dev-agents-gw.dev.sealights.co/api/v3/agents/agent-events";
    private static final String FAKE_BODY = "{}";
    private List<String> filesToDelete = new ArrayList<String>();

    @BeforeMethod
    public void beforeMethod() {
        this.cleanup();
    }

    @AfterMethod
    public void afterMethod() {
        this.cleanup();
    }

    @Test
    public void logHttpRequest_logLocationNotSet_fileNotCreated() {
        Assert.assertNull((Object)this.runLogger("GET", SMAPLE_URL), (String)"Request file should not be created");
    }

    @Test
    public void logHttpRequest_logLocationSet_fileCreated() {
        System.setProperty("sl.httpRequestsLogLocation", FILE_ROOT);
        this.testFileCreated("GET", SMAPLE_URL);
    }

    @Test
    public void logHttpRequest_validUrls_fileCreated() {
        String[] urls;
        System.setProperty("sl.httpRequestsLogLocation", FILE_ROOT);
        for (String u : urls = new String[]{"api/v3/agents/buildend/", SMAPLE_URL, "v3/agents/buildend"}) {
            this.testFileCreated("POST", u);
        }
    }

    private void testFileCreated(String method, String url) {
        String filePathName = this.runLogger(method, url);
        Assert.assertNotNull((Object)filePathName, (String)"File name is 'null'");
        Assert.assertTrue((boolean)filePathName.contains("request-"));
        Assert.assertFalse((boolean)filePathName.contains("sealights.co"));
        File file = new File(filePathName);
        Assert.assertTrue((boolean)file.exists(), (String)String.format("File '%s' not exists", filePathName));
        Assert.assertFalse((boolean)file.getParent().endsWith("+"));
    }

    private String runLogger(String method, String url) {
        String fileName = HttpRequestLogger.logHttpRequest(method, url, FAKE_BODY);
        if (fileName != null) {
            this.filesToDelete.add(fileName);
        }
        return fileName;
    }

    private void cleanup() {
        System.clearProperty("sl.httpRequestsLogLocation");
        HttpRequestLogger.initForTestsOnly();
        for (String f : this.filesToDelete) {
            this.deleteRequestFiles(f);
        }
        this.filesToDelete.clear();
    }

    private void deleteRequestFiles(String filePathName) {
        File file = new File(filePathName);
        if (file.exists() && file.isDirectory() && file.list().length > 0) {
            for (File f : file.listFiles()) {
                f.delete();
            }
        } else {
            String fileFolder = file.getParent();
            file.delete();
            this.deleteRequestFiles(fileFolder);
        }
    }
}

