/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.token.TokenTruncated;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.Header;

public final class HttpClientLogFormatter {
    private static int printableBodySize = -1;

    public static String bodyToLogString(String bodyJson) {
        if (bodyJson == null) {
            return "";
        }
        String printable = "";
        printable = bodyJson.length() > HttpClientLogFormatter.getBodySize() ? String.format("%s...(truncated to %s Bytes)", bodyJson.substring(0, printableBodySize), printableBodySize) : bodyJson;
        return String.format(", body:'%s'", printable);
    }

    public static String logRequestStartMsg(String serviceTag, String method, String url, String token, String nullableBody) {
        return String.format("[To %s] - sending %s, url:'%s', token: %s'%s'", serviceTag, method, url, TokenTruncated.truncate(token), HttpClientLogFormatter.bodyToLogString(nullableBody));
    }

    public static String logRequestStartMsg(String serviceTag, HttpUriRequestBase httpRequest, String nullableBody) {
        return String.format("[To %s] - sending %s, url:'%s', headers: %s'%s'", serviceTag, httpRequest.getMethod(), httpRequest.getRequestUri(), HttpClientLogFormatter.collectRequestHeaders(httpRequest), HttpClientLogFormatter.bodyToLogString(nullableBody));
    }

    public static <T> String logRequestEndMsg(String serviceTag, String method, String url, SLHttpResult<T> slResult) {
        if (slResult.isStatusCodeOk()) {
            return String.format("[From %s] - responsed %s'%s'", serviceTag, HttpClientLogFormatter.toStringMethodResult(method, url, slResult), HttpClientLogFormatter.bodyToLogString(slResult.getBody()));
        }
        if (slResult.getStatusCode() == 404) {
            return String.format("[From %s] - %s (resource not found)", serviceTag, HttpClientLogFormatter.toStringMethodResult(method, url, slResult));
        }
        return String.format("[From %s] - failed %s", serviceTag, HttpClientLogFormatter.toStringMethodResult(method, url, slResult));
    }

    public static <T> String toStringMethodResult(String method, String url, SLHttpResult<T> slResult) {
        return String.format("%s url:'%s', status:%s, message:%s", method, url, slResult.getStatusCode(), slResult.getStatusMessage());
    }

    private static Map<String, String> collectRequestHeaders(HttpUriRequestBase httpRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : httpRequest.getHeaders()) {
            if (header.getName().equals("Authorization") && header.getValue().contains("Bearer ")) {
                headers.put(header.getName(), "Bearer " + TokenTruncated.truncate(header.getValue()));
                continue;
            }
            headers.put(header.getName(), header.getValue());
        }
        return headers;
    }

    private static int getBodySize() {
        if (printableBodySize > 0) {
            return printableBodySize;
        }
        printableBodySize = SLHttpConfiguration.getPrintableBodySize();
        return printableBodySize;
    }

    @Generated
    private HttpClientLogFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

