/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.http.client.SLApacheHttpClient;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.nio.file.Path;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.slf4j.Logger;

public class BlobsServiceProxyHandler
extends SLServiceProxy {
    private static final Logger LOG = LogFactory.getLogger(BlobsServiceProxyHandler.class);
    private static final String BLOB_API_URL = "/v1/agents/blobs";

    public BlobsServiceProxyHandler(String token, String server, String proxy) {
        super(token, server, proxy);
    }

    @Override
    public String getTag() {
        return "BLOB";
    }

    public void sendBlobData(String buildSessionId, String blobType, Path filePath, String remoteFileName) {
        String url = this.getServer() + BLOB_API_URL + "/" + buildSessionId + "/" + remoteFileName + "?blobType=" + blobType;
        LOG.debug("url={}", (Object)url);
        SLHttpClient httpClient = this.getHttpClient();
        FileEntity fileEntity = new FileEntity(filePath.toFile(), ContentType.APPLICATION_OCTET_STREAM);
        if (httpClient instanceof SLApacheHttpClient) {
            SLApacheHttpClient slApacheHttpClient = (SLApacheHttpClient)httpClient;
            slApacheHttpClient.sendPostRequest(new SLHttpRequest<Void>(this.getTag(), url, fileEntity, Void.class));
        }
    }

    public void sendBlobData(String buildSessionId, String blobType, Path filePath) {
        if (filePath == null) {
            LOG.warn("filePath is null, skip handling");
        }
        this.sendBlobData(buildSessionId, blobType, filePath, filePath.getFileName().toString());
    }
}

