/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.utils;

import io.sealights.onpremise.agents.infra.git.api.GitDiffsTypes;
import io.sealights.onpremise.agents.infra.git.utils.GitCommandInternalTypes;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.Printer;
import io.sealights.onpremise.agents.infra.utils.ToStringFormatter;
import java.util.Map;
import java.util.Set;

public class InternalTypesPrinter {
    public static GitDebugDataPrinter DEBUG_DATA_PRINTER = new GitDebugDataPrinter();
    private static GitDiscoveryDataPrinter DISCOVERY_DATA_PRINTER = new GitDiscoveryDataPrinter();
    private static FileDebugDataPrinter FILES_DEBUG_DATA_PRINTER = new FileDebugDataPrinter();

    public static String toString(GitCommandInternalTypes.GitDiscoveryData value) {
        return DISCOVERY_DATA_PRINTER.toString(value);
    }

    public static String toString(GitCommandInternalTypes.GitDebugData value) {
        return DEBUG_DATA_PRINTER.toStringShort(value);
    }

    public static String toString(GitCommandInternalTypes.FilesDebugData value) {
        return FILES_DEBUG_DATA_PRINTER.toString(value);
    }

    public static class FileDebugDataPrinter
    implements Printer<GitCommandInternalTypes.FilesDebugData> {
        private static final String FILES_SHORT_FORMAT = "added: %s, deleted: %s, modified: %s, renamed: %s, renamedAndModified: %s";
        private static final String FULL_DATA_FILES_FORMAT = "[%-16s(%3s)] - %s\n";

        @Override
        public String toString(GitCommandInternalTypes.FilesDebugData value) {
            return this.toStringShort(value);
        }

        public String toStringShort(GitCommandInternalTypes.FilesDebugData value) {
            StringBuilder builder = new StringBuilder();
            if (value.isEmpty()) {
                builder.append("empty");
            } else {
                builder.append(String.format(FILES_SHORT_FORMAT, value.getAddedFiles().size(), value.getDeletedFiles().size(), value.getModifiedFiles().size(), value.getRenamedFiles().size(), value.getRenamedAndModifiedFiles().size()));
            }
            return builder.toString();
        }

        public String toStringFullData(Map<String, GitCommandInternalTypes.FilesDebugData> value) {
            StringBuilder builder = new StringBuilder();
            if (value.isEmpty()) {
                builder.append("empty");
            } else {
                builder.append("\n");
                for (String module : value.keySet()) {
                    builder.append(this.toStringFullData(value.get(module)));
                }
            }
            return builder.toString();
        }

        private String toStringFullData(GitCommandInternalTypes.FilesDebugData value) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n").append(this.toString("ADDED", value.getAddedFiles())).append(this.toString("DELETED", value.getDeletedFiles())).append(this.toString("MODIFIED ", value.getModifiedFiles())).append(this.toString("RENAMED", value.getRenamedFiles())).append(this.toString("RENAMED_MODIFIED", value.getRenamedAndModifiedFiles()));
            return builder.toString();
        }

        private String toString(String title, Set<?> list) {
            if (!list.isEmpty()) {
                return String.format(FULL_DATA_FILES_FORMAT, title, list.size(), JsonObjectMapper.toJson(list));
            }
            return "";
        }

        private String toString(String title, Map<?, ?> map2) {
            if (!map2.isEmpty()) {
                return String.format(FULL_DATA_FILES_FORMAT, title, map2.size(), JsonObjectMapper.toJson(map2));
            }
            return "";
        }
    }

    public static class GitDebugDataPrinter
    implements Printer<GitCommandInternalTypes.GitDebugData> {
        @Override
        public String toString(GitCommandInternalTypes.GitDebugData value) {
            return this.toStringShort(value);
        }

        public String toStringShort(GitCommandInternalTypes.GitDebugData value) {
            StringBuilder builder = new StringBuilder();
            builder.append(FILES_DEBUG_DATA_PRINTER.toStringShort(value.getFilesDebugData()));
            if (!value.getIgnoredInLogFiles().isEmpty()) {
                builder.append(", ignored files: ").append(value.getIgnoredInLogFiles().size());
            }
            return builder.toString();
        }

        public String toStringIgnoredFiles(GitCommandInternalTypes.GitDebugData value) {
            return ToStringFormatter.toString(value.getIgnoredInLogFiles());
        }

        public String toStringFullData(GitCommandInternalTypes.GitDebugData value) {
            StringBuilder builder = new StringBuilder();
            builder.append(FILES_DEBUG_DATA_PRINTER.toStringFullData(value.getFilesDebugData()));
            if (!value.getIgnoredInLogFiles().isEmpty()) {
                builder.append("ignored files:").append(this.toStringIgnoredFiles(value));
            }
            return builder.toString();
        }
    }

    public static class GitDiscoveryDataPrinter
    implements Printer<GitCommandInternalTypes.GitDiscoveryData> {
        @Override
        public String toString(GitCommandInternalTypes.GitDiscoveryData value) {
            return String.format("%ngitData:%s %noldToNewMap:%s%ndebugData:%s%nfiles:%s", value.getGitData(), value.getOldToNewFileNames(), value.getDebugData(), this.toString(value.getFiles()));
        }

        @Override
        public String toString(GitDiffsTypes.FileDiffsMap value) {
            StringBuilder builder = new StringBuilder();
            builder.append(ToStringFormatter.toString(value));
            return builder.toString();
        }
    }
}

