/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.utils;

import io.sealights.onpremise.agents.infra.git.configuration.GitExecInfo;
import io.sealights.onpremise.agents.infra.git.configuration.GitWorkConfiguration;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkMonitor;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.infra.utils.TextFileUtils;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import lombok.Generated;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;

public class GitRepo {
    private static Logger LOG = LogFactory.getLogger(GitRepo.class);
    protected static final String MAVEN_OUTPUT_DIR = PathUtils.join("target", "classes");
    protected static final String GRADLE_OUTPUT_DIR = PathUtils.join("build", "classes");
    private static final String REPO_NOT_FOUND_ERROR_FMT = "Failed to find the .git folder for workspacepath='%s'. This may cause mismatch in the paths reported by agent and SCM (Github, Bitbucket, etc.) and even no QRs.";
    private static final String GIT_FOLDER_MSG_FMT = "repository path: '%s'; workspacepath: '%s'; config file ";
    private static final String CONFIG_CONTENT_MSG_FMT = "content:%n%s";
    private static final String CONFIG_NOT_FOUND_MSG = "not found";
    private static final String NULL_GIT_MSG_FMT = "Unable to %s.'Git' object is 'null'";
    private static final String GIT_ROOT = ".git";
    private static final String GIT_CONFIG = "config";
    private static final String REMOTE = "remote";
    private static final String ORIGIN = "origin";
    private static final String URL = "url";
    private GitWorkConfiguration configuration;
    private String workspacePath;
    private Git git;
    private GitWorkMonitor gitWorkMonitor;
    private String repoUrl = "";
    private String repoPath;
    private GitExecInfo gitExecInfo = new GitExecInfo();

    public GitRepo(GitWorkConfiguration configuration, GitWorkMonitor gitWorkMonitor) {
        this.configuration = configuration;
        this.workspacePath = configuration.getWorkspacePath();
        this.gitWorkMonitor = gitWorkMonitor;
    }

    public static GitRepo createGitRepoForTest(Git git, GitWorkMonitor gitWorkMonitor) {
        return new GitRepo(git, gitWorkMonitor);
    }

    private GitRepo(Git git, GitWorkMonitor gitWorkMonitor) {
        this.git = git;
        this.gitWorkMonitor = gitWorkMonitor;
    }

    public void initGit() {
        if (this.git != null) {
            return;
        }
        this.discoverGitRepoFolder();
        this.discoverGitExe();
    }

    public boolean isGitExeFound() {
        return this.gitExecInfo.isGitExecFound();
    }

    public String getGitExecPath() {
        return this.gitExecInfo.getExecPath();
    }

    protected void discoverGitExe() {
        if (this.getConfiguration().getGitExecPath() != null) {
            this.gitExecInfo.setExecPath(FileAndFolderUtils.resolveAbsolutePath(this.getConfiguration().getGitExecPath()) + File.separator + "git");
        }
        this.gitExecInfo = (GitExecInfo)this.gitWorkMonitor.getCommandFactory().createGitVersionCliCommand(this).run();
    }

    protected void normalizeWorkingPath() {
        if (this.workspacePath == null) {
            this.workspacePath = ".";
            return;
        }
        int outputDirIndex = this.lookForOutputDirIndex();
        if (outputDirIndex == 0) {
            this.workspacePath = ".";
        } else if (outputDirIndex != -1) {
            this.workspacePath = this.workspacePath.substring(0, outputDirIndex - 1);
        }
    }

    protected void discoverGitRepoFolder() {
        this.normalizeWorkingPath();
        String wsAbsolutePath = FileAndFolderUtils.resolveAbsolutePath(this.workspacePath);
        LOG.debug("Looking for a git repository in a workspacepath:'{}'", (Object)wsAbsolutePath);
        File gitFolder = this.findGitFolder(wsAbsolutePath);
        if (gitFolder == null) {
            this.notifyGitNotFound(wsAbsolutePath, null);
        } else {
            this.repoPath = gitFolder.getAbsolutePath();
            try {
                LOG.info("Found a git repository:'{}' in a workspacepath:'{}'", (Object)gitFolder, (Object)wsAbsolutePath);
                this.git = Git.open(gitFolder);
                this.notifyGitConfig(gitFolder.getAbsolutePath(), wsAbsolutePath);
                this.initRepoUrl();
            }
            catch (Exception e) {
                this.notifyGitNotFound(wsAbsolutePath, e);
            }
        }
    }

    private int lookForOutputDirIndex() {
        int outputDirIndex = this.workspacePath.indexOf(MAVEN_OUTPUT_DIR);
        if (outputDirIndex == -1) {
            outputDirIndex = this.workspacePath.indexOf(GRADLE_OUTPUT_DIR);
        }
        return outputDirIndex;
    }

    protected String initRepoUrl() {
        try {
            if (this.git == null) {
                LOG.warn(String.format(NULL_GIT_MSG_FMT, "get repository url"));
            } else {
                Repository repository = this.git.getRepository();
                this.repoUrl = this.resolveRemoteUrl(repository.getConfig());
                if (StringUtils.isNullOrEmpty(this.repoUrl)) {
                    LOG.warn("repository remote url was not found");
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unable to get repository url.", e);
        }
        return this.repoUrl;
    }

    private String resolveRemoteUrl(Config storedConfig) {
        String url;
        block1: {
            Set<String> remotes;
            block0: {
                url = "";
                remotes = storedConfig.getSubsections(REMOTE);
                if (!remotes.contains(ORIGIN)) break block0;
                url = storedConfig.getString(REMOTE, ORIGIN, URL);
                LOG.info("Found repository url '{}' for remote 'origin'", (Object)url);
                break block1;
            }
            Iterator<String> iterator2 = remotes.iterator();
            if (!iterator2.hasNext()) break block1;
            String r = iterator2.next();
            url = storedConfig.getString(REMOTE, r, URL);
            LOG.info("Found repository url '{}' for remote '{}'", (Object)url, (Object)r);
        }
        return url;
    }

    private File findGitFolder(String path) {
        LOG.debug("Looking for repository folder at '{}'.", (Object)path);
        if (path == null) {
            LOG.warn("Got null as 'path'.");
            return null;
        }
        File workspace = new File(path);
        if (!workspace.isDirectory()) {
            LOG.warn("The argument 'path' '" + path + "' is not a directory.");
            return null;
        }
        File f = this.loopFilesToFindGitFolder(workspace);
        if (f != null) {
            return f;
        }
        if (workspace != null && workspace.getParentFile() != null && (f = this.findGitFolder((workspace = workspace.getParentFile()).getAbsolutePath())) != null) {
            return f;
        }
        return null;
    }

    private File loopFilesToFindGitFolder(File parent) {
        if (parent == null) {
            LOG.info("loopFilesToFindGitFolder - got 'null' as a parent file.");
            return null;
        }
        if (!parent.isDirectory()) {
            LOG.info("loopFilesToFindGitFolder - got parent that is not directory: '" + parent + "'.");
            return null;
        }
        File[] files = parent.listFiles();
        if (files == null) {
            LOG.info("loopFilesToFindGitFolder - couldn't get files inside parent '" + parent + "'");
            return null;
        }
        for (File f : files) {
            if (f == null || !GIT_ROOT.equals(f.getName())) continue;
            if (!f.isDirectory()) {
                LOG.warn("The repository path '" + f.getAbsolutePath() + "' is a file and not a directory.");
                continue;
            }
            return f;
        }
        return null;
    }

    private void notifyGitConfig(String gitPath, String wsAbsolutePath) {
        String config = this.readGitConfiguration(gitPath);
        String gitInfoMsg = String.format(GIT_FOLDER_MSG_FMT, gitPath, wsAbsolutePath);
        if (config != null) {
            this.gitWorkMonitor.addGitRepoConfiguration(gitInfoMsg + String.format(CONFIG_CONTENT_MSG_FMT, config), false);
        } else {
            this.gitWorkMonitor.addGitRepoConfiguration(gitInfoMsg + CONFIG_NOT_FOUND_MSG, true);
        }
    }

    private String readGitConfiguration(String gitPath) {
        File configFile = new File(gitPath + File.separator + GIT_CONFIG);
        if (configFile.exists()) {
            try {
                return TextFileUtils.getContent(configFile.getAbsolutePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOG.warn("repository config file not found in path '{}'", (Object)gitPath);
        return null;
    }

    private void notifyGitNotFound(String wsAbsolutePath, Exception error) {
        if (error == null) {
            this.gitWorkMonitor.addWarning(String.format(REPO_NOT_FOUND_ERROR_FMT, wsAbsolutePath));
        } else {
            this.gitWorkMonitor.addException(String.format(REPO_NOT_FOUND_ERROR_FMT, wsAbsolutePath), this.getClass(), error);
        }
    }

    @Generated
    public GitWorkConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String getWorkspacePath() {
        return this.workspacePath;
    }

    @Generated
    public Git getGit() {
        return this.git;
    }

    @Generated
    public GitWorkMonitor getGitWorkMonitor() {
        return this.gitWorkMonitor;
    }

    @Generated
    public String getRepoUrl() {
        return this.repoUrl;
    }

    @Generated
    public String getRepoPath() {
        return this.repoPath;
    }

    @Generated
    public GitExecInfo getGitExecInfo() {
        return this.gitExecInfo;
    }

    @Generated
    public void setConfiguration(GitWorkConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setWorkspacePath(String workspacePath) {
        this.workspacePath = workspacePath;
    }

    @Generated
    public void setGit(Git git) {
        this.git = git;
    }

    @Generated
    public void setGitWorkMonitor(GitWorkMonitor gitWorkMonitor) {
        this.gitWorkMonitor = gitWorkMonitor;
    }

    @Generated
    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    @Generated
    public void setRepoPath(String repoPath) {
        this.repoPath = repoPath;
    }

    @Generated
    public void setGitExecInfo(GitExecInfo gitExecInfo) {
        this.gitExecInfo = gitExecInfo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitRepo)) {
            return false;
        }
        GitRepo other = (GitRepo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GitWorkConfiguration this$configuration = this.getConfiguration();
        GitWorkConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$workspacePath = this.getWorkspacePath();
        String other$workspacePath = other.getWorkspacePath();
        if (this$workspacePath == null ? other$workspacePath != null : !this$workspacePath.equals(other$workspacePath)) {
            return false;
        }
        Git this$git = this.getGit();
        Git other$git = other.getGit();
        if (this$git == null ? other$git != null : !this$git.equals(other$git)) {
            return false;
        }
        GitWorkMonitor this$gitWorkMonitor = this.getGitWorkMonitor();
        GitWorkMonitor other$gitWorkMonitor = other.getGitWorkMonitor();
        if (this$gitWorkMonitor == null ? other$gitWorkMonitor != null : !((Object)this$gitWorkMonitor).equals(other$gitWorkMonitor)) {
            return false;
        }
        String this$repoUrl = this.getRepoUrl();
        String other$repoUrl = other.getRepoUrl();
        if (this$repoUrl == null ? other$repoUrl != null : !this$repoUrl.equals(other$repoUrl)) {
            return false;
        }
        String this$repoPath = this.getRepoPath();
        String other$repoPath = other.getRepoPath();
        if (this$repoPath == null ? other$repoPath != null : !this$repoPath.equals(other$repoPath)) {
            return false;
        }
        GitExecInfo this$gitExecInfo = this.getGitExecInfo();
        GitExecInfo other$gitExecInfo = other.getGitExecInfo();
        return !(this$gitExecInfo == null ? other$gitExecInfo != null : !((Object)this$gitExecInfo).equals(other$gitExecInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitRepo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GitWorkConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $workspacePath = this.getWorkspacePath();
        result = result * 59 + ($workspacePath == null ? 43 : $workspacePath.hashCode());
        Git $git = this.getGit();
        result = result * 59 + ($git == null ? 43 : $git.hashCode());
        GitWorkMonitor $gitWorkMonitor = this.getGitWorkMonitor();
        result = result * 59 + ($gitWorkMonitor == null ? 43 : ((Object)$gitWorkMonitor).hashCode());
        String $repoUrl = this.getRepoUrl();
        result = result * 59 + ($repoUrl == null ? 43 : $repoUrl.hashCode());
        String $repoPath = this.getRepoPath();
        result = result * 59 + ($repoPath == null ? 43 : $repoPath.hashCode());
        GitExecInfo $gitExecInfo = this.getGitExecInfo();
        result = result * 59 + ($gitExecInfo == null ? 43 : ((Object)$gitExecInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitRepo(configuration=" + this.getConfiguration() + ", workspacePath=" + this.getWorkspacePath() + ", git=" + this.getGit() + ", gitWorkMonitor=" + this.getGitWorkMonitor() + ", repoUrl=" + this.getRepoUrl() + ", repoPath=" + this.getRepoPath() + ", gitExecInfo=" + this.getGitExecInfo() + ")";
    }
}

