/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.utils;

import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class GitFilesLookup {
    private static final String SLASH = "/";
    private Map<String, List<String>> treeFilesMap = new HashMap<String, List<String>>();

    public void addGitFile(String filePathName) {
        String fileName = this.extractFileName(filePathName);
        this.putEntry(fileName, filePathName);
    }

    public String getMatchingFile(String pathNameLookup) {
        String lookupName = this.extractFileName(pathNameLookup);
        return this.getMatchingGitFolder(lookupName, pathNameLookup);
    }

    public Set<String> getFileNames() {
        return this.treeFilesMap.keySet();
    }

    public int getSize() {
        int cnt = 0;
        for (String key : this.treeFilesMap.keySet()) {
            cnt += this.treeFilesMap.get(key).size();
        }
        return cnt;
    }

    private void putEntry(String fileName, String fileFolder) {
        if (this.treeFilesMap.containsKey(fileName)) {
            this.treeFilesMap.get(fileName).add(fileFolder);
        } else {
            ArrayList<String> folders = new ArrayList<String>();
            folders.add(fileFolder);
            this.treeFilesMap.put(fileName, folders);
        }
    }

    private String getMatchingGitFolder(String lookupName, String lookupFolder) {
        if (this.treeFilesMap.containsKey(lookupName)) {
            for (String f : this.treeFilesMap.get(lookupName)) {
                if (f.indexOf(lookupFolder) == -1) continue;
                return f;
            }
        }
        return null;
    }

    private String extractFileName(String filePathName) {
        if (StringUtils.isNullOrEmpty(filePathName)) {
            return "";
        }
        int lastSlashIndex = filePathName.lastIndexOf(SLASH);
        if (lastSlashIndex != -1) {
            return filePathName.substring(lastSlashIndex + 1);
        }
        return filePathName;
    }

    @Generated
    public Map<String, List<String>> getTreeFilesMap() {
        return this.treeFilesMap;
    }

    @Generated
    public void setTreeFilesMap(Map<String, List<String>> treeFilesMap) {
        this.treeFilesMap = treeFilesMap;
    }
}

