/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.utils;

import java.io.File;

public class GitFileFilter {
    public static final String PATH_NOT_EXISTS = "/dev/null";
    protected static final String JAVA_EXT = ".java";
    protected static final String GROOVY_EXT = ".groovy";
    protected static final String KOTLIN_EXT = ".kt";
    protected static final String SRC = "src";
    protected static final String TEST = "test";
    protected static final String RESOURCES = "resources";
    protected static final String GIT_FILE_SEPARATOR = "/";
    protected static final String SRC_TEST_GIT = "src/test/";
    private static final String[] INCLUDES_END_WITH_PATTERNS = new String[]{".java", ".groovy", ".kt", "pom.xml", ".gradle"};
    protected static final String[] EXCLUDE_CONTAINS_PATTERNS = new String[]{"src/test/", "src/test/resources/"};

    public boolean match(String filePath) {
        if (filePath == null || filePath.equals(PATH_NOT_EXISTS)) {
            return true;
        }
        for (String pattern : EXCLUDE_CONTAINS_PATTERNS) {
            if (!filePath.replace(File.separator, GIT_FILE_SEPARATOR).contains(pattern)) continue;
            return false;
        }
        for (String pattern : INCLUDES_END_WITH_PATTERNS) {
            if (!filePath.endsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPathDefined(String path) {
        return path != null && !path.equals(PATH_NOT_EXISTS);
    }
}

