/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.utils;

import io.sealights.onpremise.agents.infra.git.api.FileDiffRanges;
import io.sealights.onpremise.agents.infra.git.api.GitDiffsTypes;
import io.sealights.onpremise.agents.infra.git.api.GitFilesTypes;
import io.sealights.onpremise.agents.infra.git.api.GitServiceApiTypes;
import io.sealights.onpremise.agents.infra.git.utils.FileDiffsModifier;
import io.sealights.onpremise.agents.infra.git.utils.InternalTypesPrinter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class GitCommandInternalTypes {

    public static class FilesDebugData {
        Set<String> addedFiles = new HashSet<String>();
        Set<String> deletedFiles = new HashSet<String>();
        Set<String> modifiedFiles = new HashSet<String>();
        Map<String, String> renamedFiles = new HashMap<String, String>();
        Map<String, String> renamedAndModifiedFiles = new HashMap<String, String>();

        public void clear() {
            this.addedFiles.clear();
            this.deletedFiles.clear();
            this.modifiedFiles.clear();
            this.renamedFiles.clear();
            this.renamedAndModifiedFiles.clear();
        }

        public boolean isEmpty() {
            return this.addedFiles.isEmpty() && this.deletedFiles.isEmpty() && this.modifiedFiles.isEmpty() && this.renamedFiles.isEmpty() && this.renamedAndModifiedFiles.isEmpty();
        }

        public String toString() {
            return InternalTypesPrinter.toString(this);
        }

        @Generated
        public FilesDebugData() {
        }

        @Generated
        public Set<String> getAddedFiles() {
            return this.addedFiles;
        }

        @Generated
        public Set<String> getDeletedFiles() {
            return this.deletedFiles;
        }

        @Generated
        public Set<String> getModifiedFiles() {
            return this.modifiedFiles;
        }

        @Generated
        public Map<String, String> getRenamedFiles() {
            return this.renamedFiles;
        }

        @Generated
        public Map<String, String> getRenamedAndModifiedFiles() {
            return this.renamedAndModifiedFiles;
        }

        @Generated
        public void setAddedFiles(Set<String> addedFiles) {
            this.addedFiles = addedFiles;
        }

        @Generated
        public void setDeletedFiles(Set<String> deletedFiles) {
            this.deletedFiles = deletedFiles;
        }

        @Generated
        public void setModifiedFiles(Set<String> modifiedFiles) {
            this.modifiedFiles = modifiedFiles;
        }

        @Generated
        public void setRenamedFiles(Map<String, String> renamedFiles) {
            this.renamedFiles = renamedFiles;
        }

        @Generated
        public void setRenamedAndModifiedFiles(Map<String, String> renamedAndModifiedFiles) {
            this.renamedAndModifiedFiles = renamedAndModifiedFiles;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilesDebugData)) {
                return false;
            }
            FilesDebugData other = (FilesDebugData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$addedFiles = this.getAddedFiles();
            Set<String> other$addedFiles = other.getAddedFiles();
            if (this$addedFiles == null ? other$addedFiles != null : !((Object)this$addedFiles).equals(other$addedFiles)) {
                return false;
            }
            Set<String> this$deletedFiles = this.getDeletedFiles();
            Set<String> other$deletedFiles = other.getDeletedFiles();
            if (this$deletedFiles == null ? other$deletedFiles != null : !((Object)this$deletedFiles).equals(other$deletedFiles)) {
                return false;
            }
            Set<String> this$modifiedFiles = this.getModifiedFiles();
            Set<String> other$modifiedFiles = other.getModifiedFiles();
            if (this$modifiedFiles == null ? other$modifiedFiles != null : !((Object)this$modifiedFiles).equals(other$modifiedFiles)) {
                return false;
            }
            Map<String, String> this$renamedFiles = this.getRenamedFiles();
            Map<String, String> other$renamedFiles = other.getRenamedFiles();
            if (this$renamedFiles == null ? other$renamedFiles != null : !((Object)this$renamedFiles).equals(other$renamedFiles)) {
                return false;
            }
            Map<String, String> this$renamedAndModifiedFiles = this.getRenamedAndModifiedFiles();
            Map<String, String> other$renamedAndModifiedFiles = other.getRenamedAndModifiedFiles();
            return !(this$renamedAndModifiedFiles == null ? other$renamedAndModifiedFiles != null : !((Object)this$renamedAndModifiedFiles).equals(other$renamedAndModifiedFiles));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FilesDebugData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $addedFiles = this.getAddedFiles();
            result = result * 59 + ($addedFiles == null ? 43 : ((Object)$addedFiles).hashCode());
            Set<String> $deletedFiles = this.getDeletedFiles();
            result = result * 59 + ($deletedFiles == null ? 43 : ((Object)$deletedFiles).hashCode());
            Set<String> $modifiedFiles = this.getModifiedFiles();
            result = result * 59 + ($modifiedFiles == null ? 43 : ((Object)$modifiedFiles).hashCode());
            Map<String, String> $renamedFiles = this.getRenamedFiles();
            result = result * 59 + ($renamedFiles == null ? 43 : ((Object)$renamedFiles).hashCode());
            Map<String, String> $renamedAndModifiedFiles = this.getRenamedAndModifiedFiles();
            result = result * 59 + ($renamedAndModifiedFiles == null ? 43 : ((Object)$renamedAndModifiedFiles).hashCode());
            return result;
        }
    }

    public static class GitDebugData {
        private FilesDebugData filesDebugData = new FilesDebugData();
        private Set<String> ignoredInLogFiles = new HashSet<String>();

        public void addedFile(String path) {
            this.filesDebugData.addedFiles.add(path);
        }

        public void deletedFile(String path) {
            this.filesDebugData.deletedFiles.add(path);
        }

        public void modifiedFile(String path) {
            this.filesDebugData.modifiedFiles.add(path);
        }

        public void renamedFile(String newPath, String oldPath) {
            this.filesDebugData.renamedFiles.put(newPath, oldPath);
        }

        public void renamedAndModifiedFile(String newPath, String oldPath) {
            this.filesDebugData.renamedAndModifiedFiles.put(newPath, oldPath);
        }

        public String toString() {
            return InternalTypesPrinter.toString(this);
        }

        @Generated
        public GitDebugData() {
        }

        @Generated
        public FilesDebugData getFilesDebugData() {
            return this.filesDebugData;
        }

        @Generated
        public Set<String> getIgnoredInLogFiles() {
            return this.ignoredInLogFiles;
        }

        @Generated
        public void setFilesDebugData(FilesDebugData filesDebugData) {
            this.filesDebugData = filesDebugData;
        }

        @Generated
        public void setIgnoredInLogFiles(Set<String> ignoredInLogFiles) {
            this.ignoredInLogFiles = ignoredInLogFiles;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GitDebugData)) {
                return false;
            }
            GitDebugData other = (GitDebugData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FilesDebugData this$filesDebugData = this.getFilesDebugData();
            FilesDebugData other$filesDebugData = other.getFilesDebugData();
            if (this$filesDebugData == null ? other$filesDebugData != null : !((Object)this$filesDebugData).equals(other$filesDebugData)) {
                return false;
            }
            Set<String> this$ignoredInLogFiles = this.getIgnoredInLogFiles();
            Set<String> other$ignoredInLogFiles = other.getIgnoredInLogFiles();
            return !(this$ignoredInLogFiles == null ? other$ignoredInLogFiles != null : !((Object)this$ignoredInLogFiles).equals(other$ignoredInLogFiles));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GitDebugData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FilesDebugData $filesDebugData = this.getFilesDebugData();
            result = result * 59 + ($filesDebugData == null ? 43 : ((Object)$filesDebugData).hashCode());
            Set<String> $ignoredInLogFiles = this.getIgnoredInLogFiles();
            result = result * 59 + ($ignoredInLogFiles == null ? 43 : ((Object)$ignoredInLogFiles).hashCode());
            return result;
        }
    }

    public static class GitDiscoveryData {
        private static final String DEFAULT_MODULE = "all";
        private String referenceId;
        private GitServiceApiTypes.GitData gitData;
        private GitDebugData debugData = new GitDebugData();
        private Map<String, String> oldToNewFileNames = new HashMap<String, String>();
        private GitDiffsTypes.FileDiffsMap files = new GitDiffsTypes.FileDiffsMap();

        public GitDiscoveryData() {
            this(DEFAULT_MODULE);
        }

        public GitDiscoveryData(String gitFolder) {
            this.gitData = new GitServiceApiTypes.GitData();
        }

        public void putFile(String filePath, GitDiffsTypes.FileDiffs fileDifs) {
            this.files.put(filePath, fileDifs);
            switch (fileDifs.getStatus()) {
                case added: {
                    this.debugData.addedFile(filePath);
                    break;
                }
                case deleted: {
                    this.debugData.deletedFile(filePath);
                    break;
                }
                case modified: {
                    this.debugData.modifiedFile(filePath);
                    break;
                }
                case renamed: {
                    this.debugData.renamedFile(filePath, fileDifs.getOldPath());
                    this.oldToNewFileNames.put(fileDifs.getOldPath(), filePath);
                    break;
                }
                case renamedAndModified: {
                    this.debugData.renamedAndModifiedFile(filePath, fileDifs.getOldPath());
                    this.oldToNewFileNames.put(fileDifs.getOldPath(), filePath);
                }
            }
        }

        public void putIgnoredFile(String filePath) {
            this.debugData.getIgnoredInLogFiles().add(filePath);
        }

        public boolean addFileCommitIndex(String filePath, Integer commitIndex) {
            String actualFilePath = this.getNewNameIfFileRenamed(filePath);
            return this.files.updateFile(actualFilePath, commitIndex, new FileDiffsModifier<Integer>(){

                @Override
                public boolean modify(GitDiffsTypes.FileDiffs fileDiffs, Integer commitIndex) {
                    fileDiffs.addCommitIndex(commitIndex);
                    return true;
                }
            });
        }

        public boolean addFileDiffRanges(FileDiffRanges fileRanges) {
            return this.files.updateFile(fileRanges.getFileName(), fileRanges.getDiffRanges(), new FileDiffsModifier<List<FileDiffRanges.DiffRanges>>(){

                @Override
                public boolean modify(GitDiffsTypes.FileDiffs fileDiffs, List<FileDiffRanges.DiffRanges> data2) {
                    fileDiffs.setTouchedLines(data2);
                    return true;
                }
            });
        }

        private String getNewNameIfFileRenamed(String filePath) {
            String newName = this.oldToNewFileNames.get(filePath);
            return newName != null ? newName : filePath;
        }

        public void addDicoveredFilesToBuildDiffs() {
            this.gitData.getBuildDiff().getModules().add(new GitDiffsTypes.ModuleFiles(DEFAULT_MODULE, this.files));
        }

        public void setDiffDone() {
            this.gitData.getBuildDiff().setDiffDone(true);
        }

        public List<GitFilesTypes.GitCommitData> getCommitDetails() {
            return this.gitData.getCommitDetails();
        }

        public List<GitFilesTypes.ContributorData> getContributors() {
            return this.gitData.getContributors();
        }

        public boolean isDiffDone() {
            return this.gitData.getBuildDiff().isDiffDone();
        }

        public boolean isFilesEmpty() {
            return this.files.isEmpty();
        }

        public String toString() {
            return InternalTypesPrinter.toString(this);
        }

        @Generated
        public String getReferenceId() {
            return this.referenceId;
        }

        @Generated
        public GitServiceApiTypes.GitData getGitData() {
            return this.gitData;
        }

        @Generated
        public GitDebugData getDebugData() {
            return this.debugData;
        }

        @Generated
        public Map<String, String> getOldToNewFileNames() {
            return this.oldToNewFileNames;
        }

        @Generated
        public GitDiffsTypes.FileDiffsMap getFiles() {
            return this.files;
        }

        @Generated
        public void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Generated
        public void setGitData(GitServiceApiTypes.GitData gitData) {
            this.gitData = gitData;
        }

        @Generated
        public void setDebugData(GitDebugData debugData) {
            this.debugData = debugData;
        }

        @Generated
        public void setOldToNewFileNames(Map<String, String> oldToNewFileNames) {
            this.oldToNewFileNames = oldToNewFileNames;
        }

        @Generated
        public void setFiles(GitDiffsTypes.FileDiffsMap files) {
            this.files = files;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GitDiscoveryData)) {
                return false;
            }
            GitDiscoveryData other = (GitDiscoveryData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$referenceId = this.getReferenceId();
            String other$referenceId = other.getReferenceId();
            if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
                return false;
            }
            GitServiceApiTypes.GitData this$gitData = this.getGitData();
            GitServiceApiTypes.GitData other$gitData = other.getGitData();
            if (this$gitData == null ? other$gitData != null : !((Object)this$gitData).equals(other$gitData)) {
                return false;
            }
            GitDebugData this$debugData = this.getDebugData();
            GitDebugData other$debugData = other.getDebugData();
            if (this$debugData == null ? other$debugData != null : !((Object)this$debugData).equals(other$debugData)) {
                return false;
            }
            Map<String, String> this$oldToNewFileNames = this.getOldToNewFileNames();
            Map<String, String> other$oldToNewFileNames = other.getOldToNewFileNames();
            if (this$oldToNewFileNames == null ? other$oldToNewFileNames != null : !((Object)this$oldToNewFileNames).equals(other$oldToNewFileNames)) {
                return false;
            }
            GitDiffsTypes.FileDiffsMap this$files = this.getFiles();
            GitDiffsTypes.FileDiffsMap other$files = other.getFiles();
            return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GitDiscoveryData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $referenceId = this.getReferenceId();
            result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
            GitServiceApiTypes.GitData $gitData = this.getGitData();
            result = result * 59 + ($gitData == null ? 43 : ((Object)$gitData).hashCode());
            GitDebugData $debugData = this.getDebugData();
            result = result * 59 + ($debugData == null ? 43 : ((Object)$debugData).hashCode());
            Map<String, String> $oldToNewFileNames = this.getOldToNewFileNames();
            result = result * 59 + ($oldToNewFileNames == null ? 43 : ((Object)$oldToNewFileNames).hashCode());
            GitDiffsTypes.FileDiffsMap $files = this.getFiles();
            result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
            return result;
        }
    }
}

