/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.utils;

import io.sealights.onpremise.agents.infra.git.controller.GitWorkMonitor;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import lombok.Generated;
import org.eclipse.jgit.api.Git;
import org.slf4j.Logger;

public abstract class GitCommand<T> {
    private static Logger LOG = LogFactory.getLogger(GitCommand.class);
    public static final String GIT_COLLECT_ERR = "Failed to collect git ";
    private static final String GIT_NOT_FOUND = "Cannot collect git data - git was not found";
    private GitRepo gitRepo;

    public T run() {
        try {
            if (this.gitRepo.getGit() != null) {
                return this.collectData();
            }
            LOG.warn(GIT_NOT_FOUND);
        }
        catch (Throwable e) {
            this.gitRepo.getGitWorkMonitor().addException(GIT_COLLECT_ERR + this.getErrorMsg(), this.getClass(), e);
        }
        return null;
    }

    protected Git getGit() {
        return this.gitRepo.getGit();
    }

    protected GitWorkMonitor getGitWorkMonitor() {
        return this.gitRepo.getGitWorkMonitor();
    }

    protected String getErrorMsg() {
        return " data";
    }

    protected abstract T collectData();

    @Generated
    public GitRepo getGitRepo() {
        return this.gitRepo;
    }

    @Generated
    public void setGitRepo(GitRepo gitRepo) {
        this.gitRepo = gitRepo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitCommand)) {
            return false;
        }
        GitCommand other = (GitCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GitRepo this$gitRepo = this.getGitRepo();
        GitRepo other$gitRepo = other.getGitRepo();
        return !(this$gitRepo == null ? other$gitRepo != null : !((Object)this$gitRepo).equals(other$gitRepo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitCommand;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GitRepo $gitRepo = this.getGitRepo();
        result = result * 59 + ($gitRepo == null ? 43 : ((Object)$gitRepo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitCommand(gitRepo=" + this.getGitRepo() + ")";
    }

    @Generated
    public GitCommand(GitRepo gitRepo) {
        this.gitRepo = gitRepo;
    }
}

