/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.service.proxy;

import io.sealights.onpremise.agents.infra.urlbuilder.UrlBuilder;

public class GitServiceProxyRoutes {
    public static final String CODE_CHANGES = "code-changes";
    public static final String BUILDS = "builds";
    public static final String SUBMITTED = "submitted";
    public static final String REF_COMMIT = "ref-commit";

    public static String buildRefCommitUrl(String server, String bsid) {
        return GitServiceProxyRoutes.build(server, GitServiceProxyRoutes.preparePath(bsid, REF_COMMIT));
    }

    public static String buildGitDataUrl(String server, String bsid) {
        return GitServiceProxyRoutes.build(server, GitServiceProxyRoutes.preparePath(bsid, null));
    }

    public static String buildGitDataSubmittedUrl(String server, String bsid) {
        return GitServiceProxyRoutes.build(server, GitServiceProxyRoutes.preparePath(bsid, SUBMITTED));
    }

    private static String[] preparePath(String bsid, String lastFragment) {
        String[] stringArray;
        if (lastFragment != null) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "v5";
            stringArray2[1] = "agents";
            stringArray2[2] = BUILDS;
            stringArray2[3] = bsid;
            stringArray2[4] = CODE_CHANGES;
            stringArray = stringArray2;
            stringArray2[5] = lastFragment;
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "v5";
            stringArray3[1] = "agents";
            stringArray3[2] = BUILDS;
            stringArray3[3] = bsid;
            stringArray = stringArray3;
            stringArray3[4] = CODE_CHANGES;
        }
        return stringArray;
    }

    private static String build(String server, String ... path) {
        return new UrlBuilder().withHost(server).withPath(path).build();
    }
}

