/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.service.proxy;

import io.sealights.onpremise.agents.infra.git.api.GitServiceApiTypes;
import io.sealights.onpremise.agents.infra.git.api.GitServiceProxy;
import io.sealights.onpremise.agents.infra.git.configuration.GitWorkConfiguration;
import io.sealights.onpremise.agents.infra.git.controller.GitController;
import io.sealights.onpremise.agents.infra.git.service.proxy.GitHttpConfigurator;
import io.sealights.onpremise.agents.infra.git.service.proxy.GitServiceProxyRoutes;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.http.client.HttpExceptions;
import java.util.Arrays;
import java.util.List;

public class GitServiceProxyHandler
extends SLServiceProxy
implements GitServiceProxy {
    private static final List<Integer> FATAL_HTTP_GET_ERRORS = Arrays.asList(404);
    private static final List<Integer> FATAL_HTTP_POST_ERRORS = Arrays.asList(400, 404);
    private GitController gitController;

    public GitServiceProxyHandler(GitWorkConfiguration cfg, GitController gitController) {
        super(cfg);
        this.gitController = gitController;
    }

    @Override
    public boolean getGitDataSubmitted(final String bsid) {
        SLHttpResult errorResult = new SLHttpResult();
        SLHttpResult<GitServiceApiTypes.GetGitDataSubmittedResponse> result = this.executeGitProxyRequest(new GitProxyRequest<GitServiceApiTypes.GetGitDataSubmittedResponse>(){

            @Override
            public SLHttpResult<GitServiceApiTypes.GetGitDataSubmittedResponse> execute() {
                return GitServiceProxyHandler.this.sendGetRetry(new SLHttpRequest<GitServiceApiTypes.GetGitDataSubmittedResponse>(GitServiceProxyHandler.this.getTag(), GitServiceProxyRoutes.buildGitDataSubmittedUrl(GitServiceProxyHandler.this.getServer(), bsid), GitServiceApiTypes.GetGitDataSubmittedResponse.class));
            }
        }, "getGitDataSubmitted", errorResult);
        if (result.isStatusCodeOk()) {
            return ((GitServiceApiTypes.GitDataSumbitted)result.getResponseObject().getData()).isSubmitted();
        }
        return false;
    }

    @Override
    public SLHttpResult<GitServiceApiTypes.GetRefCommitResponse> getRefCommit(final String bsid) {
        SLHttpResult errorResult = new SLHttpResult();
        SLHttpResult<GitServiceApiTypes.GetRefCommitResponse> result = this.executeGitProxyRequest(new GitProxyRequest<GitServiceApiTypes.GetRefCommitResponse>(){

            @Override
            public SLHttpResult<GitServiceApiTypes.GetRefCommitResponse> execute() {
                return GitServiceProxyHandler.this.sendGetRetry(new SLHttpRequest<GitServiceApiTypes.GetRefCommitResponse>(GitServiceProxyHandler.this.getTag(), GitServiceProxyRoutes.buildRefCommitUrl(GitServiceProxyHandler.this.getServer(), bsid), GitServiceApiTypes.GetRefCommitResponse.class));
            }
        }, "resolveRefCommit", errorResult);
        return result;
    }

    @Override
    public boolean sendGitData(final String bsid, final GitServiceApiTypes.GitData request) {
        SLHttpResult errorResult = new SLHttpResult();
        SLHttpResult<GitServiceApiTypes.SimpleResponse> result = this.executeGitProxyRequest(new GitProxyRequest<GitServiceApiTypes.SimpleResponse>(){

            @Override
            public SLHttpResult<GitServiceApiTypes.SimpleResponse> execute() {
                return GitServiceProxyHandler.this.sendPostRetry(new SLHttpRequest<GitServiceApiTypes.SimpleResponse>(GitServiceProxyHandler.this.getTag(), GitServiceProxyRoutes.buildGitDataUrl(GitServiceProxyHandler.this.getServer(), bsid), request, GitServiceApiTypes.SimpleResponse.class));
            }
        }, "sendGitData", errorResult);
        return result.isStatusCodeOk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends GitServiceApiTypes.SimpleResponse> SLHttpResult<T> executeGitProxyRequest(GitProxyRequest<T> gitProxyRequest, String errorContext, SLHttpResult<T> errorResult) {
        GitHttpConfigurator gitHttpConfigurator = new GitHttpConfigurator();
        try {
            gitHttpConfigurator.setGitHttpProperties();
            SLHttpResult<T> result = gitProxyRequest.execute();
            if (!result.isStatusCodeOk()) {
                this.handleError(errorContext, result.getStatusCode(), (GitServiceApiTypes.SimpleResponse)result.getResponseObject());
            }
            SLHttpResult<T> sLHttpResult = result;
            return sLHttpResult;
        }
        catch (HttpExceptions.SLHttpException e) {
            if (e.getResult() != null) {
                this.handleError(errorContext, e.getResult());
                errorResult.setStatusCode(e.getResult().getStatusCode());
            } else {
                this.handleError(errorContext, e);
            }
        }
        catch (Throwable e) {
            this.handleError(errorContext, e);
        }
        finally {
            gitHttpConfigurator.restoreHttpProperties();
        }
        return errorResult;
    }

    private <T> SLHttpResult<T> sendPostRetry(SLHttpRequest<T> request) {
        return this.getHttpClient().sendRequestRetry(request, new SLHttpClient.RequestRetry<T>(){

            @Override
            public SLHttpResult<T> execute(SLHttpRequest<T> request) {
                return GitServiceProxyHandler.this.getHttpClient().sendPostRequest(request);
            }

            @Override
            public boolean isRecoverableError(int httpCode) {
                if (FATAL_HTTP_POST_ERRORS.contains(httpCode)) {
                    return false;
                }
                return super.isRecoverableError(httpCode);
            }
        });
    }

    private <T> SLHttpResult<T> sendGetRetry(SLHttpRequest<T> request) {
        return this.getHttpClient().sendRequestRetry(request, new SLHttpClient.RequestRetry<T>(){

            @Override
            public SLHttpResult<T> execute(SLHttpRequest<T> request) {
                return GitServiceProxyHandler.this.getHttpClient().sendGetRequest(request);
            }

            @Override
            public boolean isRecoverableError(int httpCode) {
                if (FATAL_HTTP_GET_ERRORS.contains(httpCode)) {
                    return false;
                }
                return super.isRecoverableError(httpCode);
            }
        });
    }

    private void handleError(String context, int httpStatus, GitServiceApiTypes.SimpleResponse responseData) {
        this.gitController.getGitWorkMonitor().addError(String.format("request '%s' failed, status:%s, %s", context, httpStatus, responseData));
    }

    private void handleError(String context, SLHttpResult<?> errorResult) {
        this.gitController.getGitWorkMonitor().addError(String.format("request '%s' failed, status:%s, error:{%s}", context, errorResult.getStatusCode(), errorResult.getStatusMessage()));
    }

    private void handleError(String context, Throwable error) {
        this.gitController.getGitWorkMonitor().addException(String.format("request '%s' failed with exception", context), this.getClass(), error);
    }

    @Override
    public String getTag() {
        return "GDS";
    }

    public static interface GitProxyRequest<T> {
        public SLHttpResult<T> execute();
    }
}

