/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.service.proxy;

import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;

public class GitHttpConfigurator {
    protected static final int DEFAULT_MAX_ATTEMPTS = 3;
    protected static final int DEFAULT_ATTEMPT_INTERVAL_MSEC = 2000;
    private int httpMaxAttemptsSysPropValue = -1;
    private int httpAttemptIntervalSysPropValue = -1;

    public void setGitHttpProperties() {
        this.httpMaxAttemptsSysPropValue = SLHttpConfiguration.getMaxAttempts();
        this.httpAttemptIntervalSysPropValue = SLHttpConfiguration.getAttemptInterval();
        int gitproxyMaxAttempts = SystemPropertiesHelper.getIntProperty("sl.gitProxyMaxAttempts", 3);
        SystemPropertiesHelper.setProperty("sl.httpMaxAttempts", gitproxyMaxAttempts);
        int gitproxyAttemptInterval = SystemPropertiesHelper.getIntProperty("sl.gitProxyAttemptInterval", 2000);
        SystemPropertiesHelper.setProperty("sl.httpAttemptInterval", gitproxyAttemptInterval);
    }

    public void restoreHttpProperties() {
        if (this.httpMaxAttemptsSysPropValue == Integer.MIN_VALUE) {
            System.clearProperty("sl.httpMaxAttempts");
        } else {
            SystemPropertiesHelper.setProperty("sl.httpMaxAttempts", this.httpMaxAttemptsSysPropValue);
        }
        if (this.httpAttemptIntervalSysPropValue == Integer.MIN_VALUE) {
            System.clearProperty("sl.httpAttemptInterval");
        } else {
            SystemPropertiesHelper.setProperty("sl.httpAttemptInterval", this.httpAttemptIntervalSysPropValue);
        }
    }
}

