/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.jgit.commands;

import io.sealights.onpremise.agents.infra.git.jgit.commands.TreeFilesConsumer;
import io.sealights.onpremise.agents.infra.git.utils.GitCommand;
import io.sealights.onpremise.agents.infra.git.utils.GitFileFilter;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.Iterator;
import lombok.Generated;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;

public abstract class GitTreeCommand<T>
extends GitCommand<T>
implements TreeFilesConsumer<T> {
    private static Logger LOG = LogFactory.getLogger(GitTreeCommand.class);
    private static final String TREE_FILES_COLLECT = "tree files collect";
    private RevCommit headCommit;
    private GitFileFilter filter = new GitFileFilter();

    public GitTreeCommand(GitRepo gitRepo) {
        super(gitRepo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected T collectData() {
        try (TreeWalk treeWalk = new TreeWalk(this.getGit().getRepository());){
            RevTree tree = this.getHeadCommitTree();
            if (tree == null) {
                Object t = this.getConsumedData();
                return t;
            }
            treeWalk.addTree(tree);
            treeWalk.setRecursive(true);
            treeWalk.setPostOrderTraversal(false);
            while (treeWalk.next()) {
                if (!this.filter.match(treeWalk.getPathString())) continue;
                this.consume(treeWalk);
            }
            Object t = this.getConsumedData();
            return t;
        }
    }

    @Override
    protected String getErrorMsg() {
        return TREE_FILES_COLLECT;
    }

    public String getHeadCommitId() {
        if (this.headCommit != null) {
            return this.headCommit.getName();
        }
        return null;
    }

    private RevTree getHeadCommitTree() {
        if (this.headCommit == null) {
            LogCommand logCmd = this.getGit().log().setMaxCount(1);
            try {
                Object gitLog = logCmd.call();
                Iterator iterator2 = gitLog.iterator();
                while (iterator2.hasNext()) {
                    RevCommit revCommit;
                    this.headCommit = revCommit = (RevCommit)iterator2.next();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.headCommit != null) {
            LOG.info("Collecting files tree of HEAD commit {}", (Object)this.headCommit.getName());
            return this.headCommit.getTree();
        }
        this.getGitWorkMonitor().addWarning("HEAD commit is undefined, cannot collect files tree");
        return null;
    }

    @Generated
    public RevCommit getHeadCommit() {
        return this.headCommit;
    }

    @Generated
    public GitFileFilter getFilter() {
        return this.filter;
    }

    @Generated
    public void setHeadCommit(RevCommit headCommit) {
        this.headCommit = headCommit;
    }

    @Generated
    public void setFilter(GitFileFilter filter) {
        this.filter = filter;
    }

    @Override
    @Generated
    public String toString() {
        return "GitTreeCommand(headCommit=" + this.getHeadCommit() + ", filter=" + this.getFilter() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitTreeCommand)) {
            return false;
        }
        GitTreeCommand other = (GitTreeCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RevCommit this$headCommit = this.getHeadCommit();
        RevCommit other$headCommit = other.getHeadCommit();
        if (this$headCommit == null ? other$headCommit != null : !((Object)this$headCommit).equals(other$headCommit)) {
            return false;
        }
        GitFileFilter this$filter = this.getFilter();
        GitFileFilter other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitTreeCommand;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RevCommit $headCommit = this.getHeadCommit();
        result = result * 59 + ($headCommit == null ? 43 : ((Object)$headCommit).hashCode());
        GitFileFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }
}

