/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.jgit.commands;

import io.sealights.onpremise.agents.infra.git.utils.GitCommand;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.Iterator;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;

public class GitHeadCommitCommand
extends GitCommand<String> {
    private static Logger LOG = LogFactory.getLogger(GitHeadCommitCommand.class);

    public GitHeadCommitCommand(GitRepo gitRepo) {
        super(gitRepo);
    }

    @Override
    protected String collectData() {
        LOG.debug("retrieving head commit ...");
        RevCommit headCommit = this.getHeadLogEntry();
        if (headCommit != null) {
            LOG.info("found head commit {}", (Object)headCommit.getName());
            return headCommit.getName();
        }
        return null;
    }

    private RevCommit getHeadLogEntry() {
        RevCommit headCommit = null;
        try {
            LogCommand logCmd = this.getGit().log().setMaxCount(1);
            Object gitLog = logCmd.call();
            Iterator iterator2 = gitLog.iterator();
            if (iterator2.hasNext()) {
                RevCommit revCommit;
                headCommit = revCommit = (RevCommit)iterator2.next();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return headCommit;
    }
}

