/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.jgit.commands;

import io.sealights.onpremise.agents.infra.git.jgit.commands.GitTreeCommand;
import io.sealights.onpremise.agents.infra.git.utils.GitFilesLookup;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.logging.LogLevelToStringFormatter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;

public class GitFilesLookupCommand
extends GitTreeCommand<GitFilesLookup> {
    private static Logger LOG = LogFactory.getLogger(GitFilesLookupCommand.class);
    private GitFilesLookup filesLookup = new GitFilesLookup();

    public GitFilesLookupCommand(GitRepo gitRepo) {
        super(gitRepo);
    }

    @Override
    public void consume(TreeWalk treeWalk) {
        this.filesLookup.addGitFile(treeWalk.getPathString());
    }

    @Override
    public GitFilesLookup getConsumedData() {
        return this.filesLookup;
    }

    @Override
    protected GitFilesLookup collectData() {
        super.collectData();
        LOG.info("collected {} file names from 'git'", (Object)this.filesLookup.getSize());
        LOG.debug("File names :\n{}", (Object)LogLevelToStringFormatter.toString(Level.DEBUG, this.filesLookup.getTreeFilesMap()));
        return this.filesLookup;
    }
}

