/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.controller;

import io.sealights.onpremise.agents.infra.git.api.GitServiceApiTypes;
import io.sealights.onpremise.agents.infra.git.controller.GitController;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkProcStep;

public class SubmitGitDataStep
extends GitWorkProcStep<Boolean, GitServiceApiTypes.GitData> {
    private static final String GIT_DATA_SUBMITTED_FMT = "Git data submitted for bsid:%s";
    private static final String GIT_DATA_SUBMIT_ERROR_FMT = "Git data submit error for bsid:%s";
    private GitServiceApiTypes.GitData gitData;
    private boolean sentOk;

    public SubmitGitDataStep(GitController controller) {
        super(controller);
    }

    @Override
    public void setInput(GitServiceApiTypes.GitData gitData) {
        this.gitData = gitData;
    }

    @Override
    public Boolean getData() {
        return this.sentOk;
    }

    @Override
    public boolean execute() {
        String bsid = this.getCfg().getBuildSessionId();
        if (this.getGitServiceProxy().sendGitData(bsid, this.gitData)) {
            this.getGitWorkMonitor().addInfo(String.format(GIT_DATA_SUBMITTED_FMT, bsid), true);
            this.sentOk = true;
        } else {
            this.getGitWorkMonitor().addError(String.format(GIT_DATA_SUBMIT_ERROR_FMT, bsid));
            this.sentOk = false;
        }
        return this.sentOk;
    }
}

