/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.controller;

import io.sealights.onpremise.agents.infra.git.api.GitFilesTypes;
import io.sealights.onpremise.agents.infra.git.api.GitServiceApiTypes;
import io.sealights.onpremise.agents.infra.git.controller.GitController;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkProcStep;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import lombok.Generated;

public class PrepareRefCommitStep
extends GitWorkProcStep<GitFilesTypes.RefCommitData, Void> {
    private static final String GET_REF_COMMIT_FAILED_FMT = "Git ref commit for bsid:%s was not resolved, git data collection is skipped";
    private GitFilesTypes.RefCommitData refCommitData;

    public PrepareRefCommitStep(GitController controller) {
        super(controller);
    }

    @Override
    public boolean execute() {
        this.getRefCommitFromServer();
        if (this.refCommitData != null) {
            this.resetSendFullData();
            this.getGitWorkMonitor().addInfo("using " + this.refCommitData, true);
            return true;
        }
        this.getGitWorkMonitor().addError(String.format(GET_REF_COMMIT_FAILED_FMT, this.getCfg().getBuildSessionId()));
        return false;
    }

    @Override
    public void setInput(Void input) {
    }

    @Override
    public GitFilesTypes.RefCommitData getData() {
        return this.refCommitData;
    }

    protected void getRefCommitFromServer() {
        SLHttpResult<GitServiceApiTypes.GetRefCommitResponse> result = this.getGitServiceProxy().getRefCommit(this.getCfg().getBuildSessionId());
        if (result.isStatusCodeOk()) {
            this.refCommitData = (GitFilesTypes.RefCommitData)result.getResponseObject().getData();
        }
    }

    protected void resetSendFullData() {
        if (this.refCommitData.isSendFullData()) {
            this.refCommitData.setSendFullData(false);
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrepareRefCommitStep)) {
            return false;
        }
        PrepareRefCommitStep other = (PrepareRefCommitStep)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitFilesTypes.RefCommitData this$refCommitData = this.refCommitData;
        GitFilesTypes.RefCommitData other$refCommitData = other.refCommitData;
        return !(this$refCommitData == null ? other$refCommitData != null : !((Object)this$refCommitData).equals(other$refCommitData));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PrepareRefCommitStep;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        GitFilesTypes.RefCommitData $refCommitData = this.refCommitData;
        result = result * 59 + ($refCommitData == null ? 43 : ((Object)$refCommitData).hashCode());
        return result;
    }
}

