/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.controller;

import io.sealights.onpremise.agents.infra.git.controller.GitController;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkProcStep;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;

public class PrepareBSDataStep
extends GitWorkProcStep<BuildSessionData, BuildSessionData> {
    private static final String IMCOMPLETE_BSDATA_ERROR_FMT = "Git data for bsid:%s was not collected due to incomplete build-session data:%s";
    private BuildSessionData bsData;

    public PrepareBSDataStep(GitController controller) {
        super(controller);
    }

    @Override
    public boolean execute() {
        if (this.bsData == null) {
            this.bsData = this.getController().getBuildSessionIdProxy().getBuildSessionData(this.getCfg().getBuildSessionId());
        }
        if (this.isValidBsData()) {
            return true;
        }
        this.getGitWorkMonitor().addError(String.format(IMCOMPLETE_BSDATA_ERROR_FMT, this.getCfg().getBuildSessionId(), this.bsData));
        return false;
    }

    @Override
    public void setInput(BuildSessionData input) {
        this.bsData = input;
    }

    @Override
    public BuildSessionData getData() {
        return this.bsData;
    }

    private boolean isValidBsData() {
        if (this.isNotNull(this.bsData) && this.isNotNull(this.bsData.getAppName()) && this.isNotNull(this.bsData.getBranchName()) && this.isNotNull(this.bsData.getBuildName()) && this.isNotNull((Object)this.bsData.getBuildSessionType())) {
            switch (this.bsData.getBuildSessionType()) {
                case BUILD: {
                    return true;
                }
                case PULLREQUEST: {
                    return this.isNotNull(this.bsData.getPullRequestParams()) && this.isNotNull(this.bsData.getPullRequestParams().getTargetBranch());
                }
            }
        }
        return false;
    }

    private boolean isNotNull(Object value) {
        return value != null;
    }
}

