/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.controller;

import io.sealights.onpremise.agentevents.engine.AgentEventsController;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.GitEvents;
import io.sealights.onpremise.agents.infra.git.controller.GitCommandFactory;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public class GitWorkMonitor {
    private static Logger LOG = LogFactory.getLogger(GitWorkMonitor.class);
    private static final String INFOS = "GIT INFOS";
    private static final String DEBUGS = "GIT DEBUGS";
    private static final String WARNINGS = "GIT WARNINGS";
    private static final String ERRORS = "GIT ERRORS";
    private static final String EXCEPTIONS = "GIT EXCEPTIONS";
    private String gitVersionInfo;
    private List<String> gitConfigurationInfos = new ArrayList<String>();
    private List<String> infos = new ArrayList<String>();
    private List<String> debugs = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();
    private List<ExceptionInfo> exceptions = new ArrayList<ExceptionInfo>();
    private boolean workDone = false;
    private GitCommandFactory commandFactory;

    public GitWorkMonitor() {
        this(new GitCommandFactory());
    }

    public GitWorkMonitor(GitCommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public boolean isEmpty() {
        return this.infos.isEmpty() && this.debugs.isEmpty() && this.warnings.isEmpty() && this.errors.isEmpty() && this.exceptions.isEmpty();
    }

    public void setWorkDone() {
        this.workDone = true;
    }

    public void setGitVersionInfo(String gitVersionInfo) {
        LOG.info(gitVersionInfo);
        this.gitVersionInfo = gitVersionInfo;
    }

    public void addGitRepoConfiguration(String value, boolean showInLog) {
        if (showInLog) {
            LOG.info(value);
        }
        this.gitConfigurationInfos.add(StringUtils.stripEndLinesAndTabs(value));
    }

    public void addGitWorkConfiguration(String value) {
        this.gitConfigurationInfos.add(value);
    }

    public void addInfo(String msg, boolean showInLog) {
        if (showInLog) {
            LOG.info(msg);
        }
        String[] lines = StringUtils.splitToLines(msg);
        this.infos.addAll(Arrays.asList(lines));
    }

    public void addDebug(String msg) {
        LOG.debug(msg);
        String[] lines = StringUtils.splitToLines(msg);
        this.debugs.addAll(Arrays.asList(lines));
    }

    public void addWarning(String warning) {
        LOG.warn(warning);
        this.warnings.add(warning);
    }

    public void addError(String error) {
        LOG.error(error);
        this.errors.add(error);
    }

    public void addException(String msg, Class<?> scope, Throwable exception) {
        this.exceptions.add(new ExceptionInfo(msg, scope, exception));
        LOG.error(msg, exception);
    }

    public void reportToCockpit(AgentEventsController eventsController) {
        if (this.workDone) {
            if (this.gitVersionInfo != null) {
                this.sendEvent(eventsController, new GitEvents.GitVersionEvent(this.gitVersionInfo, eventsController.getTimeClockDispatcher().getTimeClock()));
            }
            for (String entry : this.gitConfigurationInfos) {
                this.sendEvent(eventsController, new GitEvents.GitConfigurationEvent(entry, eventsController.getTimeClockDispatcher().getTimeClock()));
            }
            if (!this.infos.isEmpty()) {
                this.sendEvent(eventsController, new GitEvents.GitInfoEvent(this.infos, eventsController.getTimeClockDispatcher().getTimeClock()));
            }
            if (!this.debugs.isEmpty()) {
                this.sendEvent(eventsController, new GitEvents.GitDebugEvent(this.debugs, eventsController.getTimeClockDispatcher().getTimeClock()));
            }
            if (!this.warnings.isEmpty()) {
                this.sendEvent(eventsController, new GitEvents.GitWarningEvent(this.warnings, eventsController.getTimeClockDispatcher().getTimeClock()));
            }
            if (!this.errors.isEmpty()) {
                this.sendEvent(eventsController, new GitEvents.GitErrorEvent(this.errors, eventsController.getTimeClockDispatcher().getTimeClock()));
            }
            for (ExceptionInfo e : this.exceptions) {
                eventsController.sendSuperUserExceptionMessage(AgentEventsController.NotifMsgLevel.ERROR, e.getScope(), e.getMsg(), e.getException());
            }
        }
    }

    private <T extends AgentEvent> void sendEvent(AgentEventsController eventsController, T event) {
        LOG.info("Sending {}", (Object)event);
        eventsController.sendEvent(event);
    }

    public String toString() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (!this.infos.isEmpty()) {
            builder.append(this.toString(INFOS, this.infos));
        }
        if (!this.debugs.isEmpty()) {
            builder.append(this.toString(DEBUGS, this.debugs));
        }
        if (!this.warnings.isEmpty()) {
            builder.append(this.toString(WARNINGS, this.warnings));
        }
        if (!this.errors.isEmpty()) {
            builder.append(this.toString(ERRORS, this.errors));
        }
        if (!this.exceptions.isEmpty()) {
            builder.append(this.toString(EXCEPTIONS, this.exceptions));
        }
        return builder.toString();
    }

    private <T> String toString(String name, List<T> list) {
        return String.format("{\"%s\":%s}", name, JsonObjectMapper.toJson(list));
    }

    @Generated
    public String getGitVersionInfo() {
        return this.gitVersionInfo;
    }

    @Generated
    public List<String> getGitConfigurationInfos() {
        return this.gitConfigurationInfos;
    }

    @Generated
    public List<String> getInfos() {
        return this.infos;
    }

    @Generated
    public List<String> getDebugs() {
        return this.debugs;
    }

    @Generated
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Generated
    public List<String> getErrors() {
        return this.errors;
    }

    @Generated
    public List<ExceptionInfo> getExceptions() {
        return this.exceptions;
    }

    @Generated
    public boolean isWorkDone() {
        return this.workDone;
    }

    @Generated
    public GitCommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Generated
    public void setGitConfigurationInfos(List<String> gitConfigurationInfos) {
        this.gitConfigurationInfos = gitConfigurationInfos;
    }

    @Generated
    public void setInfos(List<String> infos) {
        this.infos = infos;
    }

    @Generated
    public void setDebugs(List<String> debugs) {
        this.debugs = debugs;
    }

    @Generated
    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    @Generated
    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    @Generated
    public void setExceptions(List<ExceptionInfo> exceptions) {
        this.exceptions = exceptions;
    }

    @Generated
    public void setWorkDone(boolean workDone) {
        this.workDone = workDone;
    }

    @Generated
    public void setCommandFactory(GitCommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitWorkMonitor)) {
            return false;
        }
        GitWorkMonitor other = (GitWorkMonitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isWorkDone() != other.isWorkDone()) {
            return false;
        }
        String this$gitVersionInfo = this.getGitVersionInfo();
        String other$gitVersionInfo = other.getGitVersionInfo();
        if (this$gitVersionInfo == null ? other$gitVersionInfo != null : !this$gitVersionInfo.equals(other$gitVersionInfo)) {
            return false;
        }
        List<String> this$gitConfigurationInfos = this.getGitConfigurationInfos();
        List<String> other$gitConfigurationInfos = other.getGitConfigurationInfos();
        if (this$gitConfigurationInfos == null ? other$gitConfigurationInfos != null : !((Object)this$gitConfigurationInfos).equals(other$gitConfigurationInfos)) {
            return false;
        }
        List<String> this$infos = this.getInfos();
        List<String> other$infos = other.getInfos();
        if (this$infos == null ? other$infos != null : !((Object)this$infos).equals(other$infos)) {
            return false;
        }
        List<String> this$debugs = this.getDebugs();
        List<String> other$debugs = other.getDebugs();
        if (this$debugs == null ? other$debugs != null : !((Object)this$debugs).equals(other$debugs)) {
            return false;
        }
        List<String> this$warnings = this.getWarnings();
        List<String> other$warnings = other.getWarnings();
        if (this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings)) {
            return false;
        }
        List<String> this$errors = this.getErrors();
        List<String> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<ExceptionInfo> this$exceptions = this.getExceptions();
        List<ExceptionInfo> other$exceptions = other.getExceptions();
        if (this$exceptions == null ? other$exceptions != null : !((Object)this$exceptions).equals(other$exceptions)) {
            return false;
        }
        GitCommandFactory this$commandFactory = this.getCommandFactory();
        GitCommandFactory other$commandFactory = other.getCommandFactory();
        return !(this$commandFactory == null ? other$commandFactory != null : !this$commandFactory.equals(other$commandFactory));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitWorkMonitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWorkDone() ? 79 : 97);
        String $gitVersionInfo = this.getGitVersionInfo();
        result = result * 59 + ($gitVersionInfo == null ? 43 : $gitVersionInfo.hashCode());
        List<String> $gitConfigurationInfos = this.getGitConfigurationInfos();
        result = result * 59 + ($gitConfigurationInfos == null ? 43 : ((Object)$gitConfigurationInfos).hashCode());
        List<String> $infos = this.getInfos();
        result = result * 59 + ($infos == null ? 43 : ((Object)$infos).hashCode());
        List<String> $debugs = this.getDebugs();
        result = result * 59 + ($debugs == null ? 43 : ((Object)$debugs).hashCode());
        List<String> $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        List<String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<ExceptionInfo> $exceptions = this.getExceptions();
        result = result * 59 + ($exceptions == null ? 43 : ((Object)$exceptions).hashCode());
        GitCommandFactory $commandFactory = this.getCommandFactory();
        result = result * 59 + ($commandFactory == null ? 43 : $commandFactory.hashCode());
        return result;
    }

    public static class ExceptionInfo {
        private String msg;
        private Class<?> scope;
        private Throwable exception;

        @Generated
        public String getMsg() {
            return this.msg;
        }

        @Generated
        public Class<?> getScope() {
            return this.scope;
        }

        @Generated
        public Throwable getException() {
            return this.exception;
        }

        @Generated
        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Generated
        public void setScope(Class<?> scope) {
            this.scope = scope;
        }

        @Generated
        public void setException(Throwable exception) {
            this.exception = exception;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExceptionInfo)) {
                return false;
            }
            ExceptionInfo other = (ExceptionInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            Class<?> this$scope = this.getScope();
            Class<?> other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            Throwable this$exception = this.getException();
            Throwable other$exception = other.getException();
            return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExceptionInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            Class<?> $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            Throwable $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GitWorkMonitor.ExceptionInfo(msg=" + this.getMsg() + ", scope=" + this.getScope() + ", exception=" + this.getException() + ")";
        }

        @Generated
        public ExceptionInfo(String msg, Class<?> scope, Throwable exception) {
            this.msg = msg;
            this.scope = scope;
            this.exception = exception;
        }
    }
}

