/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.controller;

import io.sealights.onpremise.agentevents.engine.AgentEventsController;
import io.sealights.onpremise.agents.infra.git.api.GitServiceProxy;
import io.sealights.onpremise.agents.infra.git.configuration.GitProvider;
import io.sealights.onpremise.agents.infra.git.configuration.GitWorkConfiguration;
import io.sealights.onpremise.agents.infra.git.configuration.SCMType;
import io.sealights.onpremise.agents.infra.git.configuration.ScmInputValidator;
import io.sealights.onpremise.agents.infra.git.controller.CollectAndSendGitDataProc;
import io.sealights.onpremise.agents.infra.git.controller.CollectFilesLookupProc;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkMonitor;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkProc;
import io.sealights.onpremise.agents.infra.git.service.proxy.GitServiceProxyHandler;
import io.sealights.onpremise.agents.infra.git.utils.GitFilesLookup;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxyHandler;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import lombok.Generated;
import org.slf4j.Logger;

public class GitController {
    private static Logger LOG = LogFactory.getLogger(GitController.class);
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static final String GIT_DATA_ERROR_FMT = "Git data for bsid:%s will not be collected, since git was not found or configured properly";
    private AgentEventsController eventsController;
    private GitRepo gitRepo;
    private GitWorkConfiguration cfg;
    private SCMType scmType;
    private GitProvider gitProvider;
    private BuildSessionServiceProxy buildSessionIdProxy;
    private GitServiceProxy gitServiceProxy;
    private GitWorkMonitor gitWorkMonitor = new GitWorkMonitor();
    private CollectFilesLookupProc collectFilesLookupProc;

    public static GitController createInstance(GitWorkConfiguration cfg, AgentEventsController eventsController) {
        GitController instance = new GitController(cfg, eventsController);
        instance.init();
        return instance;
    }

    protected GitController(GitWorkConfiguration cfg, AgentEventsController eventsController) {
        this.cfg = cfg;
        this.eventsController = eventsController;
        this.gitRepo = new GitRepo(cfg, this.gitWorkMonitor);
        this.collectFilesLookupProc = new CollectFilesLookupProc(this);
    }

    private void init() {
        this.initScmType();
        if (this.isGitRelevant()) {
            this.gitRepo.initGit();
            this.initProxies();
            this.gitWorkMonitor.addGitWorkConfiguration(this.cfg.toString());
            LOG.info("GitController was initialized");
        }
    }

    private void initScmType() {
        ScmInputValidator validator = new ScmInputValidator(this.cfg.getScmSettings());
        ScmInputValidator.ScmValidationResult scmResult = validator.validate();
        if (!scmResult.getValidationResult().getWarnings().isEmpty()) {
            String warning = scmResult.getValidationResult().toStringWarnings();
            CONSOLE_LOG.info(warning);
            this.gitWorkMonitor.addWarning(warning);
        }
        this.scmType = scmResult.getScmType();
        this.gitProvider = scmResult.getGitProvider();
    }

    public boolean collectGitData() {
        return this.collectGitData(null);
    }

    public boolean collectGitData(BuildSessionData bsData) {
        if (bsData != null) {
            this.gitWorkMonitor.setWorkDone();
        }
        return this.executeGitWorkProc(new CollectAndSendGitDataProc(this, bsData));
    }

    public GitFilesLookup collectFilesLookup() {
        this.gitWorkMonitor.setWorkDone();
        if (this.executeGitWorkProc(this.collectFilesLookupProc)) {
            return this.collectFilesLookupProc.getFilesLookup();
        }
        return new GitFilesLookup();
    }

    protected <T> boolean executeGitWorkProc(GitWorkProc<T> gitWorkProc) {
        boolean result = false;
        try {
            if (this.isGitInitialized()) {
                result = gitWorkProc.execute();
            } else {
                this.gitWorkMonitor.addWarning(String.format(GIT_DATA_ERROR_FMT, this.cfg.getBuildSessionId()));
            }
        }
        catch (Throwable e) {
            this.gitWorkMonitor.addException("Unexpected excpetion on git-work execution", this.getClass(), e);
        }
        this.gitWorkMonitor.reportToCockpit(this.eventsController);
        return result;
    }

    private void initProxies() {
        if (this.gitServiceProxy == null) {
            this.gitServiceProxy = new GitServiceProxyHandler(this.cfg, this);
        }
        if (this.buildSessionIdProxy == null) {
            this.buildSessionIdProxy = new BuildSessionServiceProxyHandler(this.cfg);
        }
    }

    private boolean isGitInitialized() {
        return this.isGitRelevant() && this.gitRepo.getGit() != null;
    }

    private boolean isGitRelevant() {
        return SCMType.git == this.scmType;
    }

    @Generated
    public AgentEventsController getEventsController() {
        return this.eventsController;
    }

    @Generated
    public GitRepo getGitRepo() {
        return this.gitRepo;
    }

    @Generated
    public GitWorkConfiguration getCfg() {
        return this.cfg;
    }

    @Generated
    public SCMType getScmType() {
        return this.scmType;
    }

    @Generated
    public GitProvider getGitProvider() {
        return this.gitProvider;
    }

    @Generated
    public BuildSessionServiceProxy getBuildSessionIdProxy() {
        return this.buildSessionIdProxy;
    }

    @Generated
    public GitServiceProxy getGitServiceProxy() {
        return this.gitServiceProxy;
    }

    @Generated
    public GitWorkMonitor getGitWorkMonitor() {
        return this.gitWorkMonitor;
    }

    @Generated
    public CollectFilesLookupProc getCollectFilesLookupProc() {
        return this.collectFilesLookupProc;
    }

    @Generated
    public void setEventsController(AgentEventsController eventsController) {
        this.eventsController = eventsController;
    }

    @Generated
    public void setGitRepo(GitRepo gitRepo) {
        this.gitRepo = gitRepo;
    }

    @Generated
    public void setCfg(GitWorkConfiguration cfg) {
        this.cfg = cfg;
    }

    @Generated
    public void setScmType(SCMType scmType) {
        this.scmType = scmType;
    }

    @Generated
    public void setGitProvider(GitProvider gitProvider) {
        this.gitProvider = gitProvider;
    }

    @Generated
    public void setBuildSessionIdProxy(BuildSessionServiceProxy buildSessionIdProxy) {
        this.buildSessionIdProxy = buildSessionIdProxy;
    }

    @Generated
    public void setGitServiceProxy(GitServiceProxy gitServiceProxy) {
        this.gitServiceProxy = gitServiceProxy;
    }

    @Generated
    public void setGitWorkMonitor(GitWorkMonitor gitWorkMonitor) {
        this.gitWorkMonitor = gitWorkMonitor;
    }

    @Generated
    public void setCollectFilesLookupProc(CollectFilesLookupProc collectFilesLookupProc) {
        this.collectFilesLookupProc = collectFilesLookupProc;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitController)) {
            return false;
        }
        GitController other = (GitController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AgentEventsController this$eventsController = this.getEventsController();
        AgentEventsController other$eventsController = other.getEventsController();
        if (this$eventsController == null ? other$eventsController != null : !((Object)this$eventsController).equals(other$eventsController)) {
            return false;
        }
        GitRepo this$gitRepo = this.getGitRepo();
        GitRepo other$gitRepo = other.getGitRepo();
        if (this$gitRepo == null ? other$gitRepo != null : !((Object)this$gitRepo).equals(other$gitRepo)) {
            return false;
        }
        GitWorkConfiguration this$cfg = this.getCfg();
        GitWorkConfiguration other$cfg = other.getCfg();
        if (this$cfg == null ? other$cfg != null : !((Object)this$cfg).equals(other$cfg)) {
            return false;
        }
        SCMType this$scmType = this.getScmType();
        SCMType other$scmType = other.getScmType();
        if (this$scmType == null ? other$scmType != null : !((Object)((Object)this$scmType)).equals((Object)other$scmType)) {
            return false;
        }
        GitProvider this$gitProvider = this.getGitProvider();
        GitProvider other$gitProvider = other.getGitProvider();
        if (this$gitProvider == null ? other$gitProvider != null : !((Object)((Object)this$gitProvider)).equals((Object)other$gitProvider)) {
            return false;
        }
        BuildSessionServiceProxy this$buildSessionIdProxy = this.getBuildSessionIdProxy();
        BuildSessionServiceProxy other$buildSessionIdProxy = other.getBuildSessionIdProxy();
        if (this$buildSessionIdProxy == null ? other$buildSessionIdProxy != null : !this$buildSessionIdProxy.equals(other$buildSessionIdProxy)) {
            return false;
        }
        GitServiceProxy this$gitServiceProxy = this.getGitServiceProxy();
        GitServiceProxy other$gitServiceProxy = other.getGitServiceProxy();
        if (this$gitServiceProxy == null ? other$gitServiceProxy != null : !this$gitServiceProxy.equals(other$gitServiceProxy)) {
            return false;
        }
        GitWorkMonitor this$gitWorkMonitor = this.getGitWorkMonitor();
        GitWorkMonitor other$gitWorkMonitor = other.getGitWorkMonitor();
        if (this$gitWorkMonitor == null ? other$gitWorkMonitor != null : !((Object)this$gitWorkMonitor).equals(other$gitWorkMonitor)) {
            return false;
        }
        CollectFilesLookupProc this$collectFilesLookupProc = this.getCollectFilesLookupProc();
        CollectFilesLookupProc other$collectFilesLookupProc = other.getCollectFilesLookupProc();
        return !(this$collectFilesLookupProc == null ? other$collectFilesLookupProc != null : !((Object)this$collectFilesLookupProc).equals(other$collectFilesLookupProc));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitController;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AgentEventsController $eventsController = this.getEventsController();
        result = result * 59 + ($eventsController == null ? 43 : ((Object)$eventsController).hashCode());
        GitRepo $gitRepo = this.getGitRepo();
        result = result * 59 + ($gitRepo == null ? 43 : ((Object)$gitRepo).hashCode());
        GitWorkConfiguration $cfg = this.getCfg();
        result = result * 59 + ($cfg == null ? 43 : ((Object)$cfg).hashCode());
        SCMType $scmType = this.getScmType();
        result = result * 59 + ($scmType == null ? 43 : ((Object)((Object)$scmType)).hashCode());
        GitProvider $gitProvider = this.getGitProvider();
        result = result * 59 + ($gitProvider == null ? 43 : ((Object)((Object)$gitProvider)).hashCode());
        BuildSessionServiceProxy $buildSessionIdProxy = this.getBuildSessionIdProxy();
        result = result * 59 + ($buildSessionIdProxy == null ? 43 : $buildSessionIdProxy.hashCode());
        GitServiceProxy $gitServiceProxy = this.getGitServiceProxy();
        result = result * 59 + ($gitServiceProxy == null ? 43 : $gitServiceProxy.hashCode());
        GitWorkMonitor $gitWorkMonitor = this.getGitWorkMonitor();
        result = result * 59 + ($gitWorkMonitor == null ? 43 : ((Object)$gitWorkMonitor).hashCode());
        CollectFilesLookupProc $collectFilesLookupProc = this.getCollectFilesLookupProc();
        result = result * 59 + ($collectFilesLookupProc == null ? 43 : ((Object)$collectFilesLookupProc).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitController(eventsController=" + this.getEventsController() + ", gitRepo=" + this.getGitRepo() + ", cfg=" + this.getCfg() + ", scmType=" + (Object)((Object)this.getScmType()) + ", gitProvider=" + (Object)((Object)this.getGitProvider()) + ", buildSessionIdProxy=" + this.getBuildSessionIdProxy() + ", gitServiceProxy=" + this.getGitServiceProxy() + ", gitWorkMonitor=" + this.getGitWorkMonitor() + ", collectFilesLookupProc=" + this.getCollectFilesLookupProc() + ")";
    }
}

