/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.controller;

import io.sealights.onpremise.agents.infra.git.api.GitDataPrinter;
import io.sealights.onpremise.agents.infra.git.api.GitDiffsTypes;
import io.sealights.onpremise.agents.infra.git.api.GitFilesTypes;
import io.sealights.onpremise.agents.infra.git.api.GitServiceApiTypes;
import io.sealights.onpremise.agents.infra.git.controller.CollectGitDataStepInput;
import io.sealights.onpremise.agents.infra.git.controller.GitController;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkProcStep;
import io.sealights.onpremise.agents.infra.git.jgit.commands.GitTreeFilesCommand;
import io.sealights.onpremise.agents.infra.git.utils.GitCommandInternalTypes;
import io.sealights.onpremise.agents.infra.git.utils.GitUtils;
import io.sealights.onpremise.agents.infra.git.utils.InternalTypesPrinter;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import lombok.Generated;
import org.slf4j.Logger;

public class CollectGitDataStep
extends GitWorkProcStep<GitServiceApiTypes.GitData, CollectGitDataStepInput> {
    private static Logger LOG = LogFactory.getLogger(CollectGitDataStep.class);
    private static final String COLLECT_FOR_REGULAR_BUILD_MSG = "collecting git data for regular build: ";
    private static final String COLLECT_FOR_PR_BUILD_MSG = "collecting git data for PR build: ";
    private static final String NO_REF_COMMIT_MSG = " (ref-commit is 'null' and sendFullDasta is 'false')";
    private GitFilesTypes.RefCommitData refCommitData;
    private BuildSessionData bsData;
    private GitCommandInternalTypes.GitDiscoveryData gitDiscoveryData = new GitCommandInternalTypes.GitDiscoveryData(this.getGitRepo().getRepoPath());

    public CollectGitDataStep(GitController controller) {
        super(controller);
        this.getData().setScmData(new GitFilesTypes.ScmData(this.getGitRepo().getRepoUrl(), this.getCfg().getScmSettings()));
    }

    @Override
    public boolean execute() {
        this.resolveReferenceId();
        if (this.getGitRepo().isGitExeFound()) {
            this.execBuildDiffs();
        } else {
            this.executeWithoutGitExec();
        }
        return true;
    }

    protected void execBuildDiffs() {
        switch (this.bsData.getBuildSessionType()) {
            case BUILD: {
                this.executeRegularBuild();
                break;
            }
            case PULLREQUEST: {
                this.executePullRequestBuild();
            }
        }
        this.gitDiscoveryData.addDicoveredFilesToBuildDiffs();
        this.getGitWorkMonitor().addInfo("collected git data summary:" + GitDataPrinter.toString(Level.INFO, this.getData()), true);
        LOG.debug("full git data:\n{}", (Object)GitDataPrinter.toString(Level.DEBUG, this.getData()));
    }

    protected void executeWithoutGitExec() {
        if (this.bsData.getBuildSessionType() == BuildSessionData.BuildSessionType.BUILD) {
            this.fillHeadCommit();
            this.setRefCommit(this.refCommitData.getCommit());
        }
        this.getGitWorkMonitor().addInfo("git data was not collected properly, since gitExec was not found on path:" + this.getGitRepo().getGitExecPath(), true);
        this.getGitWorkMonitor().addInfo("collected git data:" + GitDataPrinter.toString(Level.INFO, this.getData()), true);
    }

    @Override
    public void setInput(CollectGitDataStepInput input) {
        this.bsData = input.getBsData();
        this.refCommitData = input.getRefCommitData();
    }

    @Override
    public GitServiceApiTypes.GitData getData() {
        return this.gitDiscoveryData.getGitData();
    }

    protected void resolveReferenceId() {
        String referenceId = null;
        switch (this.bsData.getBuildSessionType()) {
            case BUILD: {
                LOG.debug("{} - build-session type {} : using ref-commit '{}' for git-cli", new Object[]{this.getClass().getSimpleName(), BuildSessionData.BuildSessionType.BUILD, GitUtils.shortId(this.refCommitData.getCommit())});
                referenceId = GitUtils.shortId(this.refCommitData.getCommit());
                break;
            }
            case PULLREQUEST: {
                LOG.debug("{} - build-session type {} : using target branch '{}' for git-cli", new Object[]{this.getClass().getSimpleName(), BuildSessionData.BuildSessionType.PULLREQUEST, this.bsData.getPullRequestParams().getTargetBranch()});
                referenceId = this.bsData.getPullRequestParams().getTargetBranch();
            }
        }
        this.gitDiscoveryData.setReferenceId(referenceId);
    }

    protected void executeRegularBuild() {
        if (this.refCommitData.isSendFullData()) {
            this.getGitWorkMonitor().addInfo("collecting git data for regular build: collecting full files tree without diffs", true);
            this.collectFullFilesTree();
            return;
        }
        this.fillHeadCommit();
        if (this.refCommitData.getCommit() != null) {
            this.getGitWorkMonitor().addInfo(COLLECT_FOR_REGULAR_BUILD_MSG + String.format("collect incremental diffs by ref-commit %s", GitUtils.shortId(this.refCommitData.getCommit())), true);
            this.collectGitDiffs();
            this.setRefCommit(this.refCommitData.getCommit());
        } else {
            this.getGitWorkMonitor().addInfo("collecting git data for regular build: collecting HEAD commit only (ref-commit is 'null' and sendFullDasta is 'false')", true);
            this.setRefCommit(this.getData().getHeadCommit());
        }
    }

    protected void executePullRequestBuild() {
        this.getGitWorkMonitor().addInfo(COLLECT_FOR_PR_BUILD_MSG + String.format("collecting diffs by target branch %s", this.bsData.getPullRequestParams().getTargetBranch()), true);
        this.fillHeadCommit();
        this.collectGitDiffs();
        this.setRefCommit(this.getData().getHeadCommit());
    }

    protected void collectGitDiffs() {
        this.gitDiscoveryData.setDiffDone();
        this.getCommandFactory().createGitDiffsCliCommand(this.getGitRepo(), this.gitDiscoveryData, this.getCfg()).run();
        this.getCommandFactory().createGitDiffRangesCliCommand(this.getGitRepo(), this.gitDiscoveryData, this.getCfg()).run();
        this.getCommandFactory().createGitLogCliCommand(this.getGitRepo(), this.gitDiscoveryData, this.getCfg()).run();
        this.reportGitDiffResults();
    }

    protected void reportGitDiffResults() {
        if (!this.getGitDiscoveryData().isFilesEmpty()) {
            this.getGitWorkMonitor().addInfo(String.format("diff files summary: %s", InternalTypesPrinter.DEBUG_DATA_PRINTER.toStringShort(this.getGitDiscoveryData().getDebugData())), true);
            if (this.getCfg().isDebugInfoEnabled()) {
                this.getGitWorkMonitor().addDebug(String.format("git-diff handling details:%s", InternalTypesPrinter.DEBUG_DATA_PRINTER.toStringFullData(this.getGitDiscoveryData().getDebugData())));
            }
        } else {
            this.getGitWorkMonitor().addInfo("No diffs detected by git-diff-cli", true);
        }
    }

    protected void collectFullFilesTree() {
        GitTreeFilesCommand getTreeCommand = this.getCommandFactory().createGitTreeFilesCommand(this.getGitRepo());
        this.gitDiscoveryData.setFiles((GitDiffsTypes.FileDiffsMap)getTreeCommand.run());
        this.setHeadCommit(getTreeCommand.getHeadCommitId());
    }

    protected void fillHeadCommit() {
        String headCommit = (String)this.getCommandFactory().createGitHeadCommitCommand(this.getGitRepo()).run();
        if (headCommit == null) {
            this.getGitWorkMonitor().addWarning("collecting git data for regular build: HEAD commit was not found (ref-commit is 'null' and sendFullDasta is 'false')");
        } else {
            this.setHeadCommit(headCommit);
        }
    }

    private void setRefCommit(String refCommit) {
        this.getData().getBuildDiff().setRefCommit(refCommit);
    }

    private void setHeadCommit(String commit) {
        this.getData().setHeadCommit(commit);
    }

    @Generated
    public GitFilesTypes.RefCommitData getRefCommitData() {
        return this.refCommitData;
    }

    @Generated
    public BuildSessionData getBsData() {
        return this.bsData;
    }

    @Generated
    public GitCommandInternalTypes.GitDiscoveryData getGitDiscoveryData() {
        return this.gitDiscoveryData;
    }

    @Generated
    public void setRefCommitData(GitFilesTypes.RefCommitData refCommitData) {
        this.refCommitData = refCommitData;
    }

    @Generated
    public void setBsData(BuildSessionData bsData) {
        this.bsData = bsData;
    }

    @Generated
    public void setGitDiscoveryData(GitCommandInternalTypes.GitDiscoveryData gitDiscoveryData) {
        this.gitDiscoveryData = gitDiscoveryData;
    }

    @Override
    @Generated
    public String toString() {
        return "CollectGitDataStep(refCommitData=" + this.getRefCommitData() + ", bsData=" + this.getBsData() + ", gitDiscoveryData=" + this.getGitDiscoveryData() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectGitDataStep)) {
            return false;
        }
        CollectGitDataStep other = (CollectGitDataStep)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitFilesTypes.RefCommitData this$refCommitData = this.getRefCommitData();
        GitFilesTypes.RefCommitData other$refCommitData = other.getRefCommitData();
        if (this$refCommitData == null ? other$refCommitData != null : !((Object)this$refCommitData).equals(other$refCommitData)) {
            return false;
        }
        BuildSessionData this$bsData = this.getBsData();
        BuildSessionData other$bsData = other.getBsData();
        if (this$bsData == null ? other$bsData != null : !((Object)this$bsData).equals(other$bsData)) {
            return false;
        }
        GitCommandInternalTypes.GitDiscoveryData this$gitDiscoveryData = this.getGitDiscoveryData();
        GitCommandInternalTypes.GitDiscoveryData other$gitDiscoveryData = other.getGitDiscoveryData();
        return !(this$gitDiscoveryData == null ? other$gitDiscoveryData != null : !((Object)this$gitDiscoveryData).equals(other$gitDiscoveryData));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CollectGitDataStep;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        GitFilesTypes.RefCommitData $refCommitData = this.getRefCommitData();
        result = result * 59 + ($refCommitData == null ? 43 : ((Object)$refCommitData).hashCode());
        BuildSessionData $bsData = this.getBsData();
        result = result * 59 + ($bsData == null ? 43 : ((Object)$bsData).hashCode());
        GitCommandInternalTypes.GitDiscoveryData $gitDiscoveryData = this.getGitDiscoveryData();
        result = result * 59 + ($gitDiscoveryData == null ? 43 : ((Object)$gitDiscoveryData).hashCode());
        return result;
    }
}

