/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.controller;

import io.sealights.onpremise.agents.infra.git.api.GitFilesTypes;
import io.sealights.onpremise.agents.infra.git.api.GitServiceApiTypes;
import io.sealights.onpremise.agents.infra.git.controller.CollectGitDataStep;
import io.sealights.onpremise.agents.infra.git.controller.CollectGitDataStepInput;
import io.sealights.onpremise.agents.infra.git.controller.GitController;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkProc;
import io.sealights.onpremise.agents.infra.git.controller.PrepareBSDataStep;
import io.sealights.onpremise.agents.infra.git.controller.PrepareRefCommitStep;
import io.sealights.onpremise.agents.infra.git.controller.SubmitGitDataStep;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import lombok.Generated;

public class CollectAndSendGitDataProc
extends GitWorkProc<Boolean> {
    private static final String GIT_DATA_ALREADY_SUBMITTED_FMT = "Git data for bsid:%s is already submitted";
    private PrepareBSDataStep prepareBSDataStep;
    private PrepareRefCommitStep prepareRefCommitStep;
    private CollectGitDataStep collectGitDataStep;
    private SubmitGitDataStep submitDataStep;
    private GitServiceApiTypes.GitData gitData;
    private BuildSessionData bsData;
    private GitFilesTypes.RefCommitData refCommitData;

    public CollectAndSendGitDataProc(GitController controller, BuildSessionData bsData) {
        super(controller);
        this.bsData = bsData;
        this.prepareBSDataStep = new PrepareBSDataStep(controller);
        this.prepareRefCommitStep = new PrepareRefCommitStep(controller);
        this.collectGitDataStep = new CollectGitDataStep(controller);
        this.submitDataStep = new SubmitGitDataStep(controller);
    }

    protected CollectAndSendGitDataProc(GitController controller, PrepareBSDataStep prepareBSDataStep, PrepareRefCommitStep prepareRefCommitStep, CollectGitDataStep collectGitDataStep, SubmitGitDataStep submitDataStep) {
        super(controller);
        this.prepareBSDataStep = prepareBSDataStep;
        this.prepareRefCommitStep = prepareRefCommitStep;
        this.collectGitDataStep = collectGitDataStep;
        this.submitDataStep = submitDataStep;
    }

    @Override
    public boolean execute() {
        if (this.getGitServiceProxy().getGitDataSubmitted(this.getCfg().getBuildSessionId())) {
            this.getGitWorkMonitor().addInfo(String.format(GIT_DATA_ALREADY_SUBMITTED_FMT, this.getCfg().getBuildSessionId()), true);
            return true;
        }
        this.bsData = (BuildSessionData)this.prepareBSDataStep.executeStep(this.bsData);
        if (this.bsData == null) {
            return false;
        }
        if (this.bsData.getBuildSessionType() == BuildSessionData.BuildSessionType.BUILD) {
            this.refCommitData = (GitFilesTypes.RefCommitData)this.prepareRefCommitStep.executeStep(null);
            if (this.refCommitData == null) {
                return false;
            }
        }
        this.gitData = (GitServiceApiTypes.GitData)this.collectGitDataStep.executeStep(new CollectGitDataStepInput(this.refCommitData, this.bsData));
        if (this.gitData == null) {
            return false;
        }
        return this.submitDataStep.executeStep(this.gitData) != null;
    }

    @Generated
    public PrepareBSDataStep getPrepareBSDataStep() {
        return this.prepareBSDataStep;
    }

    @Generated
    public PrepareRefCommitStep getPrepareRefCommitStep() {
        return this.prepareRefCommitStep;
    }

    @Generated
    public CollectGitDataStep getCollectGitDataStep() {
        return this.collectGitDataStep;
    }

    @Generated
    public SubmitGitDataStep getSubmitDataStep() {
        return this.submitDataStep;
    }

    @Generated
    public GitServiceApiTypes.GitData getGitData() {
        return this.gitData;
    }

    @Generated
    public BuildSessionData getBsData() {
        return this.bsData;
    }

    @Generated
    public GitFilesTypes.RefCommitData getRefCommitData() {
        return this.refCommitData;
    }

    @Generated
    public void setPrepareBSDataStep(PrepareBSDataStep prepareBSDataStep) {
        this.prepareBSDataStep = prepareBSDataStep;
    }

    @Generated
    public void setPrepareRefCommitStep(PrepareRefCommitStep prepareRefCommitStep) {
        this.prepareRefCommitStep = prepareRefCommitStep;
    }

    @Generated
    public void setCollectGitDataStep(CollectGitDataStep collectGitDataStep) {
        this.collectGitDataStep = collectGitDataStep;
    }

    @Generated
    public void setSubmitDataStep(SubmitGitDataStep submitDataStep) {
        this.submitDataStep = submitDataStep;
    }

    @Generated
    public void setGitData(GitServiceApiTypes.GitData gitData) {
        this.gitData = gitData;
    }

    @Generated
    public void setBsData(BuildSessionData bsData) {
        this.bsData = bsData;
    }

    @Generated
    public void setRefCommitData(GitFilesTypes.RefCommitData refCommitData) {
        this.refCommitData = refCommitData;
    }
}

