/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.configuration;

import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.git.configuration.GitProvider;
import io.sealights.onpremise.agents.infra.git.configuration.SCMType;
import io.sealights.onpremise.agents.infra.git.configuration.ScmSettings;
import lombok.Generated;

public class ScmInputValidator {
    private static final String ILLEGAL_SCM_VALUE_FORMAT = "Unknown 'scmType' value:'%s' was replaced by '%s'; supported values are:" + SCMType.valuesToString();
    private static final String UNKNOWN_GIT_PROVIDER_VALUE_FORMAT = "Unknown 'scmProvider' value:'%s' was replaced by '%s', supported values are:" + GitProvider.valuesToString();
    private ScmSettings scmInput;
    private ScmValidationResult result = new ScmValidationResult();

    public ScmInputValidator(ScmSettings scmInput) {
        this.scmInput = scmInput;
    }

    public ScmValidationResult validate() {
        this.validateScmType();
        this.validateGitProvider();
        return this.result;
    }

    private void validateScmType() {
        if (this.scmInput.getType() != null) {
            try {
                this.result.setScmType(SCMType.valueOf(this.scmInput.getType()));
            }
            catch (IllegalArgumentException e) {
                this.result.setScmType(SCMType.none);
                this.result.getValidationResult().addWarning(String.format(ILLEGAL_SCM_VALUE_FORMAT, new Object[]{this.scmInput.getType(), SCMType.none}));
            }
        }
    }

    private void validateGitProvider() {
        if (this.scmInput.getGitProvider() != null) {
            try {
                this.result.setGitProvider(GitProvider.valueOf(this.scmInput.getGitProvider()));
            }
            catch (IllegalArgumentException e) {
                this.result.setGitProvider(GitProvider.none);
                this.result.getValidationResult().addWarning(String.format(UNKNOWN_GIT_PROVIDER_VALUE_FORMAT, new Object[]{this.scmInput.getGitProvider(), GitProvider.none}));
            }
        }
    }

    @Generated
    public ScmSettings getScmInput() {
        return this.scmInput;
    }

    @Generated
    public ScmValidationResult getResult() {
        return this.result;
    }

    @Generated
    public void setScmInput(ScmSettings scmInput) {
        this.scmInput = scmInput;
    }

    @Generated
    public void setResult(ScmValidationResult result) {
        this.result = result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScmInputValidator)) {
            return false;
        }
        ScmInputValidator other = (ScmInputValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScmSettings this$scmInput = this.getScmInput();
        ScmSettings other$scmInput = other.getScmInput();
        if (this$scmInput == null ? other$scmInput != null : !((Object)this$scmInput).equals(other$scmInput)) {
            return false;
        }
        ScmValidationResult this$result = this.getResult();
        ScmValidationResult other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScmInputValidator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScmSettings $scmInput = this.getScmInput();
        result = result * 59 + ($scmInput == null ? 43 : ((Object)$scmInput).hashCode());
        ScmValidationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScmInputValidator(scmInput=" + this.getScmInput() + ", result=" + this.getResult() + ")";
    }

    public static class ScmValidationResult {
        private ValidationResult validationResult = new ValidationResult();
        private SCMType scmType = SCMType.git;
        private GitProvider gitProvider;

        public boolean isValid() {
            return this.validationResult.isValid();
        }

        @Generated
        public ScmValidationResult() {
        }

        @Generated
        public ValidationResult getValidationResult() {
            return this.validationResult;
        }

        @Generated
        public SCMType getScmType() {
            return this.scmType;
        }

        @Generated
        public GitProvider getGitProvider() {
            return this.gitProvider;
        }

        @Generated
        public void setValidationResult(ValidationResult validationResult) {
            this.validationResult = validationResult;
        }

        @Generated
        public void setScmType(SCMType scmType) {
            this.scmType = scmType;
        }

        @Generated
        public void setGitProvider(GitProvider gitProvider) {
            this.gitProvider = gitProvider;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScmValidationResult)) {
                return false;
            }
            ScmValidationResult other = (ScmValidationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ValidationResult this$validationResult = this.getValidationResult();
            ValidationResult other$validationResult = other.getValidationResult();
            if (this$validationResult == null ? other$validationResult != null : !((Object)this$validationResult).equals(other$validationResult)) {
                return false;
            }
            SCMType this$scmType = this.getScmType();
            SCMType other$scmType = other.getScmType();
            if (this$scmType == null ? other$scmType != null : !((Object)((Object)this$scmType)).equals((Object)other$scmType)) {
                return false;
            }
            GitProvider this$gitProvider = this.getGitProvider();
            GitProvider other$gitProvider = other.getGitProvider();
            return !(this$gitProvider == null ? other$gitProvider != null : !((Object)((Object)this$gitProvider)).equals((Object)other$gitProvider));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ScmValidationResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ValidationResult $validationResult = this.getValidationResult();
            result = result * 59 + ($validationResult == null ? 43 : ((Object)$validationResult).hashCode());
            SCMType $scmType = this.getScmType();
            result = result * 59 + ($scmType == null ? 43 : ((Object)((Object)$scmType)).hashCode());
            GitProvider $gitProvider = this.getGitProvider();
            result = result * 59 + ($gitProvider == null ? 43 : ((Object)((Object)$gitProvider)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ScmInputValidator.ScmValidationResult(validationResult=" + this.getValidationResult() + ", scmType=" + (Object)((Object)this.getScmType()) + ", gitProvider=" + (Object)((Object)this.getGitProvider()) + ")";
        }
    }
}

