/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.configuration;

import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.configuration.stringable.StringableConfiguration;
import io.sealights.onpremise.agents.infra.git.configuration.ScmSettings;
import io.sealights.onpremise.agents.infra.token.TokenTruncated;
import lombok.Generated;

public class GitWorkConfiguration
extends SLAgentConfiguration {
    private String buildSessionId;
    private String workspacePath;
    private String token;
    private String server;
    private String proxy;
    private ScmSettings scmSettings = new ScmSettings();
    private boolean debugInfoEnabled = true;
    private String gitExecPath;

    public GitWorkConfiguration(String workspacePath) {
        this.workspacePath = workspacePath;
    }

    public String getGitProvider() {
        return this.scmSettings.getGitProvider();
    }

    public String getScmVersion() {
        return this.scmSettings.getVersion();
    }

    public String getScmBaseUrl() {
        return this.scmSettings.getBaseUrl();
    }

    public String getScmType() {
        return this.scmSettings.getType();
    }

    @Override
    public StringableConfiguration.PropConvertList createPropConverters() {
        StringableConfiguration.PropConvertList propConverts = new StringableConfiguration.PropConvertList();
        propConverts.putSimpleProperty("buildSessionId", this.buildSessionId);
        propConverts.putSimpleProperty("workspacePath", this.workspacePath);
        propConverts.putSimpleProperty("token", TokenTruncated.truncate(this.token));
        propConverts.putSimpleProperty("server", this.server);
        propConverts.putSimpleProperty("proxy", this.proxy);
        propConverts.putSimpleProperty("gitProvider", this.getGitProvider());
        propConverts.putSimpleProperty("scmVersion", this.getScmVersion());
        propConverts.putSimpleProperty("scmBaseUrl", this.getScmBaseUrl());
        propConverts.putSimpleProperty("scmType", this.getScmType());
        propConverts.putSimpleProperty("debugInfoEnabled", this.isDebugInfoEnabled());
        propConverts.putSimpleProperty("gitExecPath", this.getGitExecPath());
        return propConverts;
    }

    public void applyConfigurationValues(SLAgentConfiguration.SLAgentConfigurationValues configurationValues) {
        if (configurationValues != null) {
            this.token = configurationValues.getToken();
            this.server = configurationValues.getServer();
            this.proxy = configurationValues.getProxy();
            this.buildSessionId = configurationValues.getBuildSessionId();
        }
    }

    public String toString() {
        return this.toStringProperties("GitWorkConfiguration", false, WITHOUT_CONVERTER);
    }

    @Override
    @Generated
    public String getBuildSessionId() {
        return this.buildSessionId;
    }

    @Generated
    public String getWorkspacePath() {
        return this.workspacePath;
    }

    @Override
    @Generated
    public String getToken() {
        return this.token;
    }

    @Override
    @Generated
    public String getServer() {
        return this.server;
    }

    @Override
    @Generated
    public String getProxy() {
        return this.proxy;
    }

    @Generated
    public ScmSettings getScmSettings() {
        return this.scmSettings;
    }

    @Generated
    public boolean isDebugInfoEnabled() {
        return this.debugInfoEnabled;
    }

    @Generated
    public String getGitExecPath() {
        return this.gitExecPath;
    }

    @Generated
    public void setBuildSessionId(String buildSessionId) {
        this.buildSessionId = buildSessionId;
    }

    @Generated
    public void setWorkspacePath(String workspacePath) {
        this.workspacePath = workspacePath;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setScmSettings(ScmSettings scmSettings) {
        this.scmSettings = scmSettings;
    }

    @Generated
    public void setDebugInfoEnabled(boolean debugInfoEnabled) {
        this.debugInfoEnabled = debugInfoEnabled;
    }

    @Generated
    public void setGitExecPath(String gitExecPath) {
        this.gitExecPath = gitExecPath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitWorkConfiguration)) {
            return false;
        }
        GitWorkConfiguration other = (GitWorkConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDebugInfoEnabled() != other.isDebugInfoEnabled()) {
            return false;
        }
        String this$buildSessionId = this.getBuildSessionId();
        String other$buildSessionId = other.getBuildSessionId();
        if (this$buildSessionId == null ? other$buildSessionId != null : !this$buildSessionId.equals(other$buildSessionId)) {
            return false;
        }
        String this$workspacePath = this.getWorkspacePath();
        String other$workspacePath = other.getWorkspacePath();
        if (this$workspacePath == null ? other$workspacePath != null : !this$workspacePath.equals(other$workspacePath)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        ScmSettings this$scmSettings = this.getScmSettings();
        ScmSettings other$scmSettings = other.getScmSettings();
        if (this$scmSettings == null ? other$scmSettings != null : !((Object)this$scmSettings).equals(other$scmSettings)) {
            return false;
        }
        String this$gitExecPath = this.getGitExecPath();
        String other$gitExecPath = other.getGitExecPath();
        return !(this$gitExecPath == null ? other$gitExecPath != null : !this$gitExecPath.equals(other$gitExecPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitWorkConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDebugInfoEnabled() ? 79 : 97);
        String $buildSessionId = this.getBuildSessionId();
        result = result * 59 + ($buildSessionId == null ? 43 : $buildSessionId.hashCode());
        String $workspacePath = this.getWorkspacePath();
        result = result * 59 + ($workspacePath == null ? 43 : $workspacePath.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        ScmSettings $scmSettings = this.getScmSettings();
        result = result * 59 + ($scmSettings == null ? 43 : ((Object)$scmSettings).hashCode());
        String $gitExecPath = this.getGitExecPath();
        result = result * 59 + ($gitExecPath == null ? 43 : $gitExecPath.hashCode());
        return result;
    }

    @Generated
    public GitWorkConfiguration() {
    }
}

