/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.rangesparser;

import io.sealights.onpremise.agents.infra.git.cli.rangesparser.InputProvider;
import java.util.LinkedList;

public class ParsingWindow {
    private InputProvider inputProvider;
    private LinkedList<String> lineQueue = new LinkedList();
    private boolean isEndOfStream = false;

    public ParsingWindow(InputProvider inputProvider) {
        this.inputProvider = inputProvider;
    }

    public String slideForward() {
        this.lineQueue.pollFirst();
        if (this.lineQueue.isEmpty()) {
            String nextLine = this.getNextLine();
            if (nextLine != null) {
                this.lineQueue.addLast(nextLine);
            }
            return nextLine;
        }
        return this.lineQueue.peekFirst();
    }

    public String getFutureLine(int distance) {
        try {
            this.resizeCursorIfNecessary(distance + 1);
            return this.lineQueue.get(distance);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private void resizeCursorIfNecessary(int newSize) {
        int numberOfLinesToLoad = newSize - this.lineQueue.size();
        for (int i = 0; i < numberOfLinesToLoad; ++i) {
            String nextLine = this.getNextLine();
            if (nextLine == null) {
                throw new IndexOutOfBoundsException("End of stream has been reached!");
            }
            this.lineQueue.addLast(nextLine);
        }
    }

    private String getNextLine() throws Exception {
        String nextLine = this.inputProvider.readLine();
        return this.getNextLineOrVirtualBlankLineAtEndOfStream(nextLine);
    }

    private String getNextLineOrVirtualBlankLineAtEndOfStream(String nextLine) {
        if (nextLine == null && !this.isEndOfStream) {
            this.isEndOfStream = true;
            return "";
        }
        return nextLine;
    }

    public String getFocusLine() {
        return this.lineQueue.element();
    }
}

