/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.rangesparser;

import io.sealights.onpremise.agents.infra.git.cli.rangesparser.GitDiffRangesParser;
import io.sealights.onpremise.agents.infra.git.cli.rangesparser.ParsingWindow;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import org.slf4j.Logger;

public enum ParserState {
    INITIAL{

        @Override
        public ParserState nextState(GitDiffRangesParser parser, ParsingWindow window) {
            return ParserState.nextHeaderOrFromFileState(window, 1.INITIAL);
        }
    }
    ,
    HEADER{

        @Override
        public ParserState nextState(GitDiffRangesParser parser, ParsingWindow window) {
            return ParserState.nextHeaderOrFromFileState(window, 2.HEADER);
        }
    }
    ,
    NEXT_HEADER{

        @Override
        public ParserState nextState(GitDiffRangesParser parser, ParsingWindow window) {
            return ParserState.nextHeaderOrFromFileState(window, 3.NEXT_HEADER);
        }
    }
    ,
    FROM_FILE{

        @Override
        public ParserState nextState(GitDiffRangesParser parser, ParsingWindow window) {
            String line = window.getFocusLine();
            if (GitDiffRangesParser.ParserMatcher.matchesToFilePattern(line)) {
                4.logTransition(line, FROM_FILE, TO_FILE);
                return TO_FILE;
            }
            throw new IllegalStateException("A FROM_FILE line ('---') must be directly followed by a TO_FILE line ('+++')!");
        }
    }
    ,
    TO_FILE{

        @Override
        public ParserState nextState(GitDiffRangesParser parser, ParsingWindow window) {
            String line = window.getFocusLine();
            if (GitDiffRangesParser.ParserMatcher.matchesHunkStartPattern(line)) {
                5.logTransition(line, TO_FILE, RANGE_START);
                return RANGE_START;
            }
            parser.addInvalidLineWarning("A TO_FILE line ('+++') must be directly followed by a HUNK_START line ('@@')!");
            return DIFF_LINE_TO_SKIP;
        }
    }
    ,
    RANGE_START{

        @Override
        public ParserState nextState(GitDiffRangesParser parser, ParsingWindow window) {
            return DIFF_LINE_TO_SKIP;
        }
    }
    ,
    DIFF_LINE_TO_SKIP{

        @Override
        public ParserState nextState(GitDiffRangesParser parser, ParsingWindow window) {
            String line = window.getFocusLine();
            if (GitDiffRangesParser.ParserMatcher.matchesStartHeaderPattern(line)) {
                7.logTransition(line, DIFF_LINE_TO_SKIP, NEXT_HEADER);
                return NEXT_HEADER;
            }
            if (GitDiffRangesParser.ParserMatcher.matchesEndPattern(line, window)) {
                7.logTransition(line, DIFF_LINE_TO_SKIP, END);
                return END;
            }
            if (GitDiffRangesParser.ParserMatcher.matchesHunkStartPattern(line)) {
                7.logTransition(line, DIFF_LINE_TO_SKIP, RANGE_START);
                return RANGE_START;
            }
            return DIFF_LINE_TO_SKIP;
        }
    }
    ,
    END{

        @Override
        public ParserState nextState(GitDiffRangesParser parser, ParsingWindow window) {
            String line = window.getFocusLine();
            8.logTransition(line, END, HEADER);
            return HEADER;
        }
    };

    private static Logger LOG;

    private static ParserState nextHeaderOrFromFileState(ParsingWindow window, ParserState fromState) {
        String line = window.getFocusLine();
        if (GitDiffRangesParser.ParserMatcher.matchesFromFilePattern(line)) {
            ParserState.logTransition(line, fromState, FROM_FILE);
            return FROM_FILE;
        }
        ParserState.logTransition(line, fromState, HEADER);
        return HEADER;
    }

    protected static void logTransition(String currentLine, ParserState fromState, ParserState toState) {
        LOG.trace(String.format("%12s -> %12s: %s", new Object[]{fromState, toState, currentLine}));
    }

    public abstract ParserState nextState(GitDiffRangesParser var1, ParsingWindow var2);

    static {
        LOG = LogFactory.getLogger(ParserState.class);
    }
}

