/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.rangesparser;

import io.sealights.onpremise.agents.infra.git.api.FileDiffRanges;
import io.sealights.onpremise.agents.infra.git.cli.rangesparser.InputProvider;
import io.sealights.onpremise.agents.infra.git.cli.rangesparser.ParserState;
import io.sealights.onpremise.agents.infra.git.cli.rangesparser.ParsingWindow;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkMonitor;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;

public class GitDiffRangesParser {
    private static Logger LOG = LogFactory.getLogger(GitDiffRangesParser.class);
    private static final String SKIPPED_RANGE_LINE_MSG = "Skipped invalid range line:";
    private static final String WRONG_RANGE_FMT = "no line ranges found in the range start line: '%s'. Expected something like '-1,5 +3,5'.";
    private static final String ILLEGAL_PARSE_STATE_FMT = "Illegal parser state '%s";
    private GitWorkMonitor gitWorkMonitor;

    public List<FileDiffRanges> parse(InputProvider inputProvider) {
        String currentLine;
        LOG.trace("Start parsing...");
        ParsingWindow window = new ParsingWindow(inputProvider);
        ParserState state = ParserState.INITIAL;
        ArrayList<FileDiffRanges> parsedDiffs = new ArrayList<FileDiffRanges>();
        FileDiffRanges currentDiff = new FileDiffRanges();
        block8: while ((currentLine = window.slideForward()) != null) {
            state = state.nextState(this, window);
            switch (state) {
                case INITIAL: 
                case HEADER: 
                case FROM_FILE: {
                    inputProvider.notifyRelevantLine(currentLine);
                }
                case DIFF_LINE_TO_SKIP: {
                    continue block8;
                }
                case TO_FILE: {
                    inputProvider.notifyRelevantLine(currentLine);
                    this.parseToFile(currentDiff, currentLine);
                    continue block8;
                }
                case RANGE_START: {
                    inputProvider.notifyRelevantLine(currentLine);
                    this.parseDiffRanges(currentDiff, currentLine);
                    continue block8;
                }
                case NEXT_HEADER: {
                    inputProvider.notifyRelevantLine(currentLine);
                }
                case END: {
                    if (!currentDiff.isEmpty()) {
                        parsedDiffs.add(currentDiff);
                    }
                    currentDiff = new FileDiffRanges();
                    continue block8;
                }
            }
            this.addInvalidLineWarning(String.format(ILLEGAL_PARSE_STATE_FMT, new Object[]{state}));
        }
        LOG.trace("Parsed: {}", (Object)parsedDiffs);
        return parsedDiffs;
    }

    public List<FileDiffRanges> parse(byte[] bytes) {
        class ByteInputProvider
        implements InputProvider {
            private BufferedReader reader;

            public ByteInputProvider(byte[] bytes) {
                ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                this.reader = new BufferedReader(new InputStreamReader(input));
            }

            @Override
            public String readLine() {
                return this.reader.readLine();
            }

            @Override
            public void notifyRelevantLine(String line) {
            }
        }
        return this.parse(new ByteInputProvider(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileDiffRanges> parse(File file) throws Exception {
        class FileInputProvider
        implements InputProvider {
            private BufferedReader reader;
            private FileInputStream input;

            public FileInputProvider(File file) throws Exception {
                this.input = new FileInputStream(file);
                this.reader = new BufferedReader(new InputStreamReader(this.input));
            }

            @Override
            public String readLine() {
                return this.reader.readLine();
            }

            @Override
            public void notifyRelevantLine(String line) {
            }

            public void close() throws Exception {
                this.input.close();
            }
        }
        try (FileInputProvider inputProvider = null;){
            inputProvider = new FileInputProvider(file);
            List<FileDiffRanges> list = this.parse(inputProvider);
            return list;
        }
    }

    private void parseDiffRanges(FileDiffRanges currentFileDiff, String currentLine) {
        Matcher matcher = ParserMatcher.LINE_RANGE_PATTERN.matcher(currentLine);
        if (matcher.matches()) {
            String range1Start = matcher.group(1);
            String range1Count = matcher.group(2) != null ? matcher.group(2) : "1";
            FileDiffRanges.Range fromRange = new FileDiffRanges.Range(Integer.valueOf(range1Start), Integer.valueOf(range1Count));
            String range2Start = matcher.group(3);
            String range2Count = matcher.group(4) != null ? matcher.group(4) : "1";
            FileDiffRanges.Range toRange = new FileDiffRanges.Range(Integer.valueOf(range2Start), Integer.valueOf(range2Count));
            FileDiffRanges.DiffRanges diffRanges = new FileDiffRanges.DiffRanges(fromRange, toRange);
            currentFileDiff.getDiffRanges().add(diffRanges);
        } else {
            this.addInvalidRangeWarning(currentLine);
        }
    }

    private void parseToFile(FileDiffRanges currentFileDiff, String currentLine) {
        currentFileDiff.setFileName(this.cutAfterTab(currentLine.substring(6)));
    }

    private String cutAfterTab(String line) {
        Pattern p = Pattern.compile("^(.*)\\t.*$");
        Matcher matcher = p.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return line;
    }

    public void addInvalidRangeWarning(String line) {
        this.gitWorkMonitor.addWarning(String.format("Skipped invalid range line:no line ranges found in the range start line: '%s'. Expected something like '-1,5 +3,5'.", line));
    }

    public void addInvalidLineWarning(String line) {
        this.gitWorkMonitor.addWarning(line);
    }

    @Generated
    public GitDiffRangesParser(GitWorkMonitor gitWorkMonitor) {
        this.gitWorkMonitor = gitWorkMonitor;
    }

    @Generated
    public GitWorkMonitor getGitWorkMonitor() {
        return this.gitWorkMonitor;
    }

    @Generated
    public void setGitWorkMonitor(GitWorkMonitor gitWorkMonitor) {
        this.gitWorkMonitor = gitWorkMonitor;
    }

    public static class ParserMatcher {
        static final String FROM_FILE = "---";
        static final String TO_FILE = "+++";
        static final String FROM_LINE = "-";
        static final String TO_LINE = "+";
        static final String START_HEADER = "diff --git";
        static final Pattern LINE_RANGE_PATTERN = Pattern.compile("^.*-([0-9]+)(?:,([0-9]+))? \\+([0-9]+)(?:,([0-9]+))?.*$");
        static final String TAB_PATTERN = "^(.*)\\t.*$";
        static final int TO_FILE_START_POSITION = 6;

        public static boolean matchesFromFilePattern(String line) {
            return line.startsWith(FROM_FILE);
        }

        public static boolean matchesToFilePattern(String line) {
            return line.startsWith(TO_FILE);
        }

        public static boolean matchesHunkStartPattern(String line) {
            return LINE_RANGE_PATTERN.matcher(line).matches();
        }

        public static boolean matchesStartHeaderPattern(String line) {
            return line.startsWith(START_HEADER);
        }

        public static boolean matchesEndPattern(String line, ParsingWindow window) {
            if ("".equals(line.trim())) {
                String futureLine;
                int i = 1;
                while ((futureLine = window.getFutureLine(i)) != null) {
                    if (ParserMatcher.matchesStartHeaderPattern(futureLine)) {
                        return false;
                    }
                    if ("".equals(futureLine.trim())) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
    }
}

