/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.parser;

import io.sealights.onpremise.agents.infra.git.cli.parser.CommitLineParseData;
import io.sealights.onpremise.agents.infra.git.cli.parser.CommitLineParser;
import io.sealights.onpremise.agents.infra.git.cli.parser.FileDiffsParser;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkMonitor;
import io.sealights.onpremise.agents.infra.utils.StringUtils;

public class GitLogCliOutputParser {
    static final String WRONG_NUMBER_OF_TOKENS_ERROR = "wrong number of tokens";
    private CommitLineParser commitLineParser;
    private FileDiffsParser fileDiffsParser;

    public GitLogCliOutputParser(GitWorkMonitor gitWorkMonitor) {
        this.commitLineParser = new CommitLineParser(gitWorkMonitor);
        this.fileDiffsParser = new FileDiffsParser(gitWorkMonitor);
    }

    public CommitLineParseData parseLine(String inputLine, CommitLineParseData commitLineParseData) {
        if (StringUtils.isNullOrEmpty(inputLine)) {
            return commitLineParseData;
        }
        CommitLineParseData.CommitParseData nextCommitData = this.commitLineParser.parse(inputLine);
        if (nextCommitData != null) {
            return new CommitLineParseData(nextCommitData);
        }
        if (commitLineParseData != null) {
            commitLineParseData.setFileParseData(this.fileDiffsParser.parse(inputLine));
        }
        return commitLineParseData;
    }
}

