/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.parser;

import io.sealights.onpremise.agents.infra.git.api.GitDiffsTypes;
import io.sealights.onpremise.agents.infra.git.cli.commands.GitCliConstants;
import io.sealights.onpremise.agents.infra.git.cli.parser.CommitLineParseData;
import io.sealights.onpremise.agents.infra.git.cli.parser.LineParser;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkMonitor;
import io.sealights.onpremise.agents.infra.git.utils.GitFileFilter;
import lombok.Generated;

public class FileDiffsParser
extends LineParser<CommitLineParseData.FileDiffsParseData> {
    private static GitFileFilter filter = new GitFileFilter();

    public FileDiffsParser(GitWorkMonitor gitWorkMonitor) {
        super(gitWorkMonitor);
    }

    @Override
    public CommitLineParseData.FileDiffsParseData parse(String line) {
        String[] columns = line.split("\t");
        if (columns.length >= GitCliConstants.DIFF_MSG_TOKENS_MIN) {
            if (filter.match(columns[1])) {
                if (columns.length == 2) {
                    return this.classifyDiff(columns[0], columns[1], null);
                }
                return this.classifyDiff(columns[0], columns[2], columns[1]);
            }
            return CommitLineParseData.FileDiffsParseData.EMPTY_FILE;
        }
        this.addSkipLineWarning(line, "wrong number of tokens");
        return null;
    }

    protected CommitLineParseData.FileDiffsParseData classifyDiff(String diff, String fileName, String oldFileName) {
        if (diff.startsWith("A")) {
            return new CommitLineParseData.FileDiffsParseData(GitDiffsTypes.GitDiffStatus.added, fileName);
        }
        if (diff.startsWith("D")) {
            return new CommitLineParseData.FileDiffsParseData(GitDiffsTypes.GitDiffStatus.deleted, fileName);
        }
        if (diff.startsWith("M")) {
            return new CommitLineParseData.FileDiffsParseData(GitDiffsTypes.GitDiffStatus.modified, fileName);
        }
        if (diff.startsWith("R")) {
            if (diff.contains("100")) {
                return new CommitLineParseData.FileDiffsParseData(GitDiffsTypes.GitDiffStatus.renamed, fileName, oldFileName);
            }
            return new CommitLineParseData.FileDiffsParseData(GitDiffsTypes.GitDiffStatus.renamedAndModified, fileName, oldFileName);
        }
        return null;
    }

    @Override
    @Generated
    public String toString() {
        return "FileDiffsParser()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileDiffsParser)) {
            return false;
        }
        FileDiffsParser other = (FileDiffsParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileDiffsParser;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

