/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.parser;

import io.sealights.onpremise.agents.infra.git.cli.parser.CommitLineParseData;
import io.sealights.onpremise.agents.infra.git.cli.parser.LineParser;
import io.sealights.onpremise.agents.infra.git.controller.GitWorkMonitor;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import lombok.Generated;

public class CommitLineParser
extends LineParser<CommitLineParseData.CommitParseData> {
    private static final String GIT_TIME_FORMAT = "EEE MMM dd HH:mm:ss yyyy Z";
    private DateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy Z", Locale.ENGLISH);

    public CommitLineParser(GitWorkMonitor gitWorkMonitor) {
        super(gitWorkMonitor);
    }

    @Override
    public CommitLineParseData.CommitParseData parse(String line) {
        String[] tokens;
        if (StringUtils.isNotEmpty(line) && (tokens = line.split("~~~")).length == 6) {
            try {
                return new CommitLineParseData.CommitParseData(tokens[0], tokens[1], tokens[2], this.dateFormat.parse(tokens[3]).getTime(), this.dateFormat.parse(tokens[4]).getTime(), tokens[5]);
            }
            catch (ParseException e) {
                this.addSkipLineWarning(line, CommitLineParser.class, e);
            }
        }
        return null;
    }

    @Generated
    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    @Generated
    public String toString() {
        return "CommitLineParser(dateFormat=" + this.getDateFormat() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommitLineParser)) {
            return false;
        }
        CommitLineParser other = (CommitLineParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateFormat this$dateFormat = this.getDateFormat();
        DateFormat other$dateFormat = other.getDateFormat();
        return !(this$dateFormat == null ? other$dateFormat != null : !((Object)this$dateFormat).equals(other$dateFormat));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommitLineParser;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DateFormat $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : ((Object)$dateFormat).hashCode());
        return result;
    }
}

