/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.commands;

import io.sealights.onpremise.agents.infra.git.cli.commands.GitCliCommand;
import io.sealights.onpremise.agents.infra.git.configuration.GitExecInfo;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.BufferedReader;
import lombok.Generated;

public class GitVersionCliCommand
extends GitCliCommand<GitExecInfo> {
    protected static final String GIT_VERSION = "git version";
    protected static final String GIT_VERSION_FOUND_FMT = "found %s";
    protected static final String GIT_EXE_NOT_FOUND_FMT = "git executable was not found on path ('%s' returned '%s'); QRs and contributors may be not reported properly.";
    private GitExecInfo gitExecInfo;

    public GitVersionCliCommand(GitRepo gitRepo) {
        super(gitRepo);
        this.gitExecInfo = gitRepo.getGitExecInfo();
    }

    @Override
    protected String getGitCliArgs() {
        return "--version";
    }

    @Override
    protected GitExecInfo collectData() {
        this.runCli();
        return this.gitExecInfo;
    }

    @Override
    protected boolean readGitOutputLine(BufferedReader reader) {
        boolean returnValue = super.readGitOutputLine(reader);
        if (!returnValue && !this.isGitExecFound()) {
            this.reportGitExecNotFound(null);
        }
        return returnValue;
    }

    @Override
    protected void handleRunCliException(String cmd, Throwable e) {
        super.handleRunCliException(cmd, e);
        this.reportGitExecNotFound(e.getMessage());
    }

    @Override
    protected boolean handleOutputLine(String line) {
        if (line.contains(GIT_VERSION)) {
            this.gitExecInfo.setGitExecFound(true);
            this.getGitWorkMonitor().setGitVersionInfo(String.format(GIT_VERSION_FOUND_FMT, StringUtils.stripEndLinesAndTabs(line)));
        } else {
            this.reportGitExecNotFound(line);
        }
        return true;
    }

    protected boolean isGitExecFound() {
        return this.gitExecInfo.isGitExecFound();
    }

    private void reportGitExecNotFound(String output) {
        this.getGitWorkMonitor().setGitVersionInfo(String.format(GIT_EXE_NOT_FOUND_FMT, this.buildCliCmd(), StringUtils.stripEndLinesAndTabs(output)));
    }

    @Override
    protected boolean doAccumulateCliOutput() {
        return true;
    }

    @Generated
    public GitExecInfo getGitExecInfo() {
        return this.gitExecInfo;
    }
}

