/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.commands;

import io.sealights.onpremise.agents.infra.git.api.GitFilesTypes;
import io.sealights.onpremise.agents.infra.git.api.GitServiceApiTypes;
import io.sealights.onpremise.agents.infra.git.cli.commands.GitDataDiscoveryCliCommand;
import io.sealights.onpremise.agents.infra.git.cli.parser.CommitLineParseData;
import io.sealights.onpremise.agents.infra.git.cli.parser.GitLogCliOutputParser;
import io.sealights.onpremise.agents.infra.git.configuration.GitWorkConfiguration;
import io.sealights.onpremise.agents.infra.git.utils.GitCommandInternalTypes;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import io.sealights.onpremise.agents.infra.git.utils.GitUtils;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public class GitLogCliCommand
extends GitDataDiscoveryCliCommand {
    private static Logger LOG = LogFactory.getLogger(GitLogCliCommand.class);
    public static final String FILES_IGNORED_MESSAGE = "Some files in commit-log were ignored; following raw data may provide the clue why. ";
    private final GitLogCliOutputParser cliOutputParser;
    private CommitLineParseData currentCommitParseData = null;
    private int currentCommitIndex = -1;

    public GitLogCliCommand(GitRepo gitRepo, GitCommandInternalTypes.GitDiscoveryData gitDiscoveryData, GitWorkConfiguration configuration) {
        super(gitRepo, gitDiscoveryData, configuration);
        this.cliOutputParser = new GitLogCliOutputParser(gitRepo.getGitWorkMonitor());
    }

    @Override
    protected String getGitCliArgs() {
        return String.format("log %s..HEAD --no-merges -M50 --name-status --pretty=\"%%H~~~%%an~~~%%ae~~~%%ad~~~%%cd~~~%%s\"", this.getReferenceId());
    }

    @Override
    protected boolean handleOutputLine(String line) {
        CommitLineParseData lineCommitParseData = this.cliOutputParser.parseLine(line, this.currentCommitParseData);
        if (lineCommitParseData == null) {
            return false;
        }
        boolean relevantCliLine = true;
        this.initCurrentCommitParseData(lineCommitParseData);
        if (!lineCommitParseData.isSameCommit(this.currentCommitParseData)) {
            this.addNewCommit(lineCommitParseData.getCommitParseData());
        }
        if (lineCommitParseData.hasFileDiffs()) {
            CommitLineParseData.FileDiffsParseData fileData = lineCommitParseData.getFileParseData();
            boolean bl = relevantCliLine = !fileData.isEmpty();
            if (relevantCliLine && !this.getGitDiscoveryData().addFileCommitIndex(fileData.getFilePath(), this.currentCommitIndex)) {
                this.getGitDiscoveryData().putIgnoredFile(fileData.getFilePath());
                LOG.trace("Ignored diff at commitIndex:{}, commit:{} - {}, status:{}, oldPath:{}", new Object[]{this.currentCommitIndex, GitUtils.shortId(this.currentCommitParseData.getCommit()), fileData.getFilePath(), fileData.getFileDiffs().getStatus(), fileData.getFileDiffs().getOldPath()});
            }
        }
        this.currentCommitParseData = lineCommitParseData;
        this.currentCommitParseData.reset();
        return relevantCliLine;
    }

    private void addNewCommit(CommitLineParseData.CommitParseData commitParseData) {
        List<GitFilesTypes.GitCommitData> commitDetails = this.getGitDiscoveryData().getCommitDetails();
        this.currentCommitIndex = commitDetails.size();
        GitFilesTypes.GitCommitData commitData = commitParseData.getGitCommitData();
        int contributorIndex = this.addCommitContributors(commitParseData);
        commitData.setIndex(this.currentCommitIndex);
        commitData.setContributorIndex(contributorIndex);
        commitDetails.add(commitData);
        this.getCliOutput().add(String.format("[COMMIT_INDEX=%s]", this.currentCommitIndex));
    }

    private int addCommitContributors(CommitLineParseData.CommitParseData commitParseData) {
        GitFilesTypes.ContributorData contributorData = new GitFilesTypes.ContributorData(commitParseData.getAuthorName(), commitParseData.getAuthorMail());
        List<GitFilesTypes.ContributorData> contributors = this.getGitDiscoveryData().getContributors();
        int index = contributors.indexOf(contributorData);
        if (index == -1) {
            index = contributors.size();
            contributorData.setIndex(index);
            contributors.add(contributorData);
        }
        return index;
    }

    private void initCurrentCommitParseData(CommitLineParseData lineCommitParseData) {
        if (this.currentCommitParseData == null) {
            this.currentCommitParseData = lineCommitParseData;
            this.addNewCommit(lineCommitParseData.getCommitParseData());
        }
    }

    @Override
    protected void reportResults() {
        if (!this.getGitDiscoveryData().getCommitDetails().isEmpty()) {
            this.getGitWorkMonitor().addInfo(String.format("collected from git-log - head-commit:%s, commits size:%s, contributors size:%s", this.gitData().getHeadCommit(), this.gitData().getCommitDetails().size(), this.gitData().getContributors().size()), true);
        } else {
            this.getGitWorkMonitor().addInfo(String.format("no new commits were found in git-log for ref-commit %s", this.getReferenceId()), true);
        }
        if (this.getConfiguration().isDebugInfoEnabled()) {
            this.getGitWorkMonitor().addDebug(String.format("GIT_LOG: cli output (%s lines): %s", this.getCliOutput().size(), this.toStringCliOuptput()));
            this.reportIgnoredFiles();
        }
    }

    protected void reportIgnoredFiles() {
        if (!this.getGitDiscoveryData().getDebugData().getIgnoredInLogFiles().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append(FILES_IGNORED_MESSAGE).append(String.format("%noldToNewFileNames:%s", this.getGitDiscoveryData().getOldToNewFileNames())).append(String.format("%nignored files:%s", this.getGitDiscoveryData().getDebugData().getIgnoredInLogFiles()));
            this.getGitWorkMonitor().addDebug(builder.toString());
        }
    }

    private GitServiceApiTypes.GitData gitData() {
        return this.getGitDiscoveryData().getGitData();
    }

    @Generated
    public GitLogCliOutputParser getCliOutputParser() {
        return this.cliOutputParser;
    }

    @Generated
    public CommitLineParseData getCurrentCommitParseData() {
        return this.currentCommitParseData;
    }

    @Generated
    public int getCurrentCommitIndex() {
        return this.currentCommitIndex;
    }

    @Generated
    public void setCurrentCommitParseData(CommitLineParseData currentCommitParseData) {
        this.currentCommitParseData = currentCommitParseData;
    }

    @Generated
    public void setCurrentCommitIndex(int currentCommitIndex) {
        this.currentCommitIndex = currentCommitIndex;
    }

    @Override
    @Generated
    public String toString() {
        return "GitLogCliCommand(cliOutputParser=" + this.getCliOutputParser() + ", currentCommitParseData=" + this.getCurrentCommitParseData() + ", currentCommitIndex=" + this.getCurrentCommitIndex() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitLogCliCommand)) {
            return false;
        }
        GitLogCliCommand other = (GitLogCliCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrentCommitIndex() != other.getCurrentCommitIndex()) {
            return false;
        }
        GitLogCliOutputParser this$cliOutputParser = this.getCliOutputParser();
        GitLogCliOutputParser other$cliOutputParser = other.getCliOutputParser();
        if (this$cliOutputParser == null ? other$cliOutputParser != null : !this$cliOutputParser.equals(other$cliOutputParser)) {
            return false;
        }
        CommitLineParseData this$currentCommitParseData = this.getCurrentCommitParseData();
        CommitLineParseData other$currentCommitParseData = other.getCurrentCommitParseData();
        return !(this$currentCommitParseData == null ? other$currentCommitParseData != null : !((Object)this$currentCommitParseData).equals(other$currentCommitParseData));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitLogCliCommand;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCurrentCommitIndex();
        GitLogCliOutputParser $cliOutputParser = this.getCliOutputParser();
        result = result * 59 + ($cliOutputParser == null ? 43 : $cliOutputParser.hashCode());
        CommitLineParseData $currentCommitParseData = this.getCurrentCommitParseData();
        result = result * 59 + ($currentCommitParseData == null ? 43 : ((Object)$currentCommitParseData).hashCode());
        return result;
    }
}

