/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.commands;

import io.sealights.onpremise.agents.infra.git.cli.commands.GitDataDiscoveryCliCommand;
import io.sealights.onpremise.agents.infra.git.cli.parser.CommitLineParseData;
import io.sealights.onpremise.agents.infra.git.cli.parser.FileDiffsParser;
import io.sealights.onpremise.agents.infra.git.configuration.GitWorkConfiguration;
import io.sealights.onpremise.agents.infra.git.utils.GitCommandInternalTypes;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import lombok.Generated;
import org.slf4j.Logger;

public class GitDiffsCliCommand
extends GitDataDiscoveryCliCommand {
    private static Logger LOG = LogFactory.getLogger(GitDiffsCliCommand.class);
    private FileDiffsParser fileDiffsParser = new FileDiffsParser(this.getGitWorkMonitor());

    public GitDiffsCliCommand(GitRepo gitRepo, GitCommandInternalTypes.GitDiscoveryData gitDiscoveryData, GitWorkConfiguration configuration) {
        super(gitRepo, gitDiscoveryData, configuration);
    }

    @Override
    protected String getGitCliArgs() {
        return String.format("diff %s...HEAD --no-merges -M50 --name-status", this.getReferenceId());
    }

    @Override
    protected boolean handleOutputLine(String outputLine) {
        LOG.trace("Parsing output line '{}'", (Object)outputLine);
        CommitLineParseData.FileDiffsParseData fileDiffsData = this.fileDiffsParser.parse(outputLine);
        if (fileDiffsData != null && !fileDiffsData.isEmpty()) {
            this.getGitDiscoveryData().putFile(fileDiffsData.getFilePath(), fileDiffsData.getFileDiffs());
            return true;
        }
        return false;
    }

    @Override
    protected void reportResults() {
        if (this.getConfiguration().isDebugInfoEnabled()) {
            this.getGitWorkMonitor().addDebug(String.format("GIT-DIFF-1: cli output (%s lines): %s", this.getCliOutput().size(), this.toStringCliOuptput()));
        }
    }

    @Generated
    public FileDiffsParser getFileDiffsParser() {
        return this.fileDiffsParser;
    }

    @Generated
    public void setFileDiffsParser(FileDiffsParser fileDiffsParser) {
        this.fileDiffsParser = fileDiffsParser;
    }

    @Override
    @Generated
    public String toString() {
        return "GitDiffsCliCommand(fileDiffsParser=" + this.getFileDiffsParser() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitDiffsCliCommand)) {
            return false;
        }
        GitDiffsCliCommand other = (GitDiffsCliCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileDiffsParser this$fileDiffsParser = this.getFileDiffsParser();
        FileDiffsParser other$fileDiffsParser = other.getFileDiffsParser();
        return !(this$fileDiffsParser == null ? other$fileDiffsParser != null : !((Object)this$fileDiffsParser).equals(other$fileDiffsParser));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitDiffsCliCommand;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        FileDiffsParser $fileDiffsParser = this.getFileDiffsParser();
        result = result * 59 + ($fileDiffsParser == null ? 43 : ((Object)$fileDiffsParser).hashCode());
        return result;
    }
}

